#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <libosso.h>

#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "userdata.h"
#include "view-main.h"
#include "glue.h"

static gboolean init_dbus(userdata_t *u) {
    DBusError error;
    gint status;

    dbus_error_init(&error);

    if (!(u->dbus = dbus_bus_get(DBUS_BUS_SESSION, &error))) {
        if (dbus_error_is_set(&error))
            g_print("Failed to get DBUS connection (%s)\n", error.message);
        else
            g_print("Failed to get DBUS connection\n");
        goto error;
    }

    dbus_connection_setup_with_g_main(u->dbus, NULL);

    status = dbus_bus_request_name(u->dbus, "com.nokia.yaspot", DBUS_NAME_FLAG_DO_NOT_QUEUE, &error);

    if (status == DBUS_REQUEST_NAME_REPLY_EXISTS) {
        g_print("Name already taken, another instance already running\n");
        goto error;
    }

    if (status != DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
        if (dbus_error_is_set(&error))
            g_print("Failed to aquire bus name (%s)\n", error.message);
        else
            g_print("Failed to aquire bus name\n");
        goto error;
    }

    g_print("connected to dbus\n");

    return TRUE;

error:
    if (u->dbus) {
        dbus_connection_unref(u->dbus);
        u->dbus = NULL;
    }
    return FALSE;
}

static void display_cb(osso_display_state_t state, gpointer data) {
    userdata_t *u = (userdata_t*)data;

    u->display_on = (state == OSSO_DISPLAY_ON);
}

int main(int argc, gchar **argv) {
    userdata_t u;
    memset(&u, 0, sizeof(userdata_t));

    /* Initialize the locale stuff: */
    setlocale (LC_ALL, "");
    bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);

    if (!g_thread_supported())
        g_thread_init(NULL);

    gdk_threads_init();
    gdk_threads_enter();

    hildon_gtk_init(&argc, &argv);

    if (!init_dbus(&u))
        goto end;

    /*if (!(u.osso = osso_initialize_with_connections(PACKAGE, VERSION, NULL, u.dbus))) {*/
    if (!(u.osso = osso_initialize(PACKAGE, VERSION, FALSE, NULL))) {
        g_print("Failed to initialize osso\n");
        goto end;
    }

    if (osso_hw_set_display_event_cb(u.osso, display_cb, &u) != OSSO_OK) {
        g_print("Failed to set display event cb\n");
    }

    u.session = yaspot_glue_init(u.dbus);

    u.program = hildon_program_get_instance();

    yaspot_show_main(&u);

    if (u.connection.connected)
        gtk_main();

    yaspot_glue_cleanup(u.session);

end:
    gdk_threads_leave();

    g_print("bye bye!\n");

    return 0;
}

// vim: expandtab

