import QtQuick 1.0
import "scripts/videolistscripts.js" as Scripts

Item {
    id: window

    property string searchQuery
    property string searchOrder
    property bool canLoadYouPorn : false

    signal loadVideoInfo(string site, variant video)
    signal playXtubeVideo(variant video)

    function setSearchQuery(site, query, order) {
        searchQuery = query
        searchOrder = order;
        if (site == "youporn") {
            youpornSearch();
        }
        else if (site == "xhamster") {
            tabView.currentIndex = 1;
        }
        else if (site == "youjizz") {
            tabView.currentIndex = 2;
        }
    }

    function youpornSearch() {
        /* Perform a search of YouPorn */

        var order = "";
        if (searchOrder = "date") {
            order = "time";
        }

        var query = searchQuery.replace(/\s/g, "+");
        var videoFeed = ("http://youporn.com/search/" + order + "?query=" + query + "&page=1");
        youpornList.setVideoFeed(videoFeed);
    }

    function xhamsterSearch() {
        /* Perform a search of xHamster */

        var order = "";
        if (searchOrder = "date") {
            order = "da";
        }
        else if (searchOrder = "views") {
            order = "vc";
        }
        else if (searchOrder = "rating") {
            order = "rt";
        }

        var query = searchQuery.replace(/\s/g, "+");
        var videoFeed = ("http://xhamster.com/search.php?q=" + query + "&s=" + order + "&page=1");
        xhamsterList.setVideoFeed(videoFeed);
    }

    function youjizzSearch() {
        /* Perform a search of YouJizz */

        var order = searchOrder;
        if ((searchOrder == "date") || (searchOrder == "relevance")) {
            order = "recent";
        }

        var query = searchQuery.replace(/\s/g, "-");
        var videoFeed = ("http://youjizz.com/search/" + order + "_" + query + "-1.html");
        youjizzList.setVideoFeed(videoFeed);
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Item {
            id: tabItem

            anchors { fill: dimmer; topMargin: 60 }

            Row {
                id: tabRow

                Item {
                    id: youpornTab

                    width: tabItem.width / 3
                    height: 40

                    BorderImage {
                        anchors.fill: youpornTab
                        source: (cuteTubeTheme == "nightred") ? "ui-images/tabred.png" : "ui-images/tab.png"
                        smooth: true
                        visible: tabView.currentIndex == 0
                    }

                    Text {
                        anchors.fill: youpornTab
                        font.pixelSize: _STANDARD_FONT_SIZE
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: tabView.currentIndex == 0 ? _TEXT_COLOR : "grey"
                        text: qsTr("YouPorn")
                    }

                    Rectangle {
                        height: 1
                        anchors { bottom: youpornTab.bottom; left: youpornTab.left; right: youpornTab.right }
                        color: _ACTIVE_COLOR_HIGH
                        opacity: 0.5
                        visible: !(tabView.currentIndex == 0)
                    }

                    MouseArea {
                        id: youpornMouseArea

                        anchors.fill: youpornTab
                        onClicked: tabView.currentIndex = 0
                    }
                }

                Item {
                    id: xhamsterTab

                    width: tabItem.width / 3
                    height: 40

                    BorderImage {
                        anchors.fill: xhamsterTab
                        source: (cuteTubeTheme == "nightred") ? "ui-images/tabred.png" : "ui-images/tab.png"
                        smooth: true
                        visible: tabView.currentIndex == 1
                    }

                    Text {
                        anchors.fill: xhamsterTab
                        font.pixelSize: _STANDARD_FONT_SIZE
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: tabView.currentIndex == 1 ? _TEXT_COLOR : "grey"
                        text: qsTr("XHamster")
                    }

                    Rectangle {
                        height: 1
                        anchors { bottom: xhamsterTab.bottom; left: xhamsterTab.left; right: xhamsterTab.right }
                        color: _ACTIVE_COLOR_HIGH
                        opacity: 0.5
                        visible: !(tabView.currentIndex == 1)
                    }

                    MouseArea {
                        id: xhamsterMouseArea

                        anchors.fill: xhamsterTab
                        onClicked: tabView.currentIndex = 1
                    }
                }

                Item {
                    id: youjizzTab

                    width: tabItem.width / 3
                    height: 40

                    BorderImage {
                        anchors.fill: youjizzTab
                        source: (cuteTubeTheme == "nightred") ? "ui-images/tabred.png" : "ui-images/tab.png"
                        smooth: true
                        visible: tabView.currentIndex == 2
                    }

                    Text {
                        anchors.fill: youjizzTab
                        font.pixelSize: _STANDARD_FONT_SIZE
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: tabView.currentIndex == 2 ? _TEXT_COLOR : "grey"
                        text: qsTr("YouJizz")
                    }

                    Rectangle {
                        height: 1
                        anchors { bottom: youjizzTab.bottom; left: youjizzTab.left; right: youjizzTab.right }
                        color: _ACTIVE_COLOR_HIGH
                        opacity: 0.5
                        visible: !(tabView.currentIndex == 2)
                    }

                    MouseArea {
                        id: youjizzMouseArea

                        anchors.fill: youjizzTab
                        onClicked: tabView.currentIndex = 2
                    }
                }
            }

            ListView {
                id: tabView

                anchors { left: tabItem.left; right: tabItem.right; top: tabRow.bottom; bottom: tabItem.bottom }
                orientation: ListView.Horizontal
                highlightMoveDuration: 200
                highlightRangeMode: ListView.StrictlyEnforceRange
                snapMode: ListView.SnapOneItem
                flickDeceleration: 500
                boundsBehavior: Flickable.StopAtBounds
                model: tabModel
                clip: true

                onCurrentIndexChanged: {
                    if ((tabView.currentIndex == 0) && (canLoadYouPorn) && (!youpornList.loaded)) {
                        youpornSearch();
                    }
                    else if ((tabView.currentIndex == 1) && (!xhamsterList.loaded)) {
                        canLoadYouPorn = true;
                        xhamsterSearch();
                    }
                    else if ((tabView.currentIndex == 2) && (!youjizzList.loaded)) {
                        canLoadYouPorn = true;
                        youjizzSearch();
                    }
                }
            }

            Item {
                width: tabView.width
                height: 100
                anchors { top: tabView.top; topMargin: (tabView.currentItem.count == 0) ? 0 : 100 }
                visible: tabView.currentItem.loading

                BusyDialog {
                    anchors.centerIn: parent
                }
            }
        }

        VisualItemModel {
            id: tabModel

            YouPornListView {
                id: youpornList

                width: tabView.width
                height: tabView.height
                opacity: (tabView.currentIndex == 0) ? 1 : 0
                onGoToVideo: loadVideoInfo("youporn", video)
                onPlayVideo: playXtubeVideo(video)
            }

            XHamsterListView {
                id: xhamsterList

                width: tabView.width
                height: tabView.height
                opacity: (tabView.currentIndex == 1) ? 1 : 0
                onGoToVideo: loadVideoInfo("xhamster", video)
                onPlayVideo: playXtubeVideo(video)
            }

            YouJizzListView {
                id: youjizzList

                width: tabView.width
                height: tabView.height
                opacity: (tabView.currentIndex == 2) ? 1 : 0
                onGoToVideo: loadVideoInfo("youjizz", video)
                onPlayVideo: playXtubeVideo(video)
            }
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.1 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
