import QtQuick 1.0
import "scripts/videolistscripts.js" as Scripts
import "scripts/createobject.js" as ObjectCreator

Item {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
    signal playVideos(variant videos)

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var results = doc.responseText.split('<a href="');
                var pattern = /movies/;
                for (var i = 1; i < results.length; i++) {
                    if (pattern.test(results[i])) {
                        var r = results[i];
                        videoListModel.append({ "link": "http://xhamster.com" + r.split('"')[0],
                                              "title": r.slice(r.indexOf("alt=\"") + 5, r.indexOf("\"/>")).replace("&amp;", "&"),
                                              "thumbnail": r.slice(r.indexOf("src=") + 5, r.indexOf("' width")),
                                              "duration": getDuration(r.slice(r.indexOf("Runtime") + 9, r.indexOf("<BR>"))) });
                    }
                }
                videoListModel.loading = false;
            }
        }
        doc.open("GET", feed);
        doc.send();
    }

    function getDuration(durationString) {
        /* Converts string to MM:SS format. */
        var a = durationString.split("m")
        var minutes = a[0];
        var seconds = a[1].slice(0, -1);
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        var duration = minutes + ":" + seconds;
        return duration;
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    function getVideoUrl(index) {
        toggleBusy(true);

        var video = videoListModel.get(index);
        var request = new XMLHttpRequest();
        request.onreadystatechange = function() {
            if (request.readyState == XMLHttpRequest.DONE) {
                var page = request.responseText.replace(/ /g,'');
                var urlPart = page.split("'file':'")[1];
                var playerUrl = "http://xhamster.com/flv2/" + urlPart.slice(0, urlPart.indexOf("\'"));
                var pos1 = urlPart.indexOf("'image':'") + 9;
                var pos2 = urlPart.indexOf(".jpg") + 4;
                thumbnail = urlPart.slice(pos1, pos2);
                var authorPart = urlPart.split("/user/")[1];
                var author = authorPart.slice(0, authorPart.indexOf('"'));
                pos1 = urlPart.indexOf("Addedon:") + 23;
                var date = urlPart.substr(pos1, 10);
                video["filePath"] = playerUrl;
                video["author"] = author;
                video["uploadDate"] = date;
                toggleBusy(false);
                playVideos([video]);
            }
        }
        request.open("GET", video.link);
        request.send();
    }

    function addVideosToDownloads() {

        toggleBusy(true);

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = videoListModel.get(videoList.checkList[i]);
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == XMLHttpRequest.DONE) {
                    var page = request.responseText.replace(/ /g,'');
                    var playerUrl = "http://xhamster.com/flv2/" + page.split("'file':'")[1].split("'")[0];

                    addDownload({ "title": video.title,
                                "thumbnail": video.thumbnail,
                                "playerUrl": playerUrl });

                    toggleBusy(false);
                }
            }
            request.open("GET", video.link);
            request.send();
        }
        videoList.checkList = [];
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No videos found")
            visible: (!videoListModel.loading) && (videoList.count == 0)
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            footer: Item {
                id: footer

                width: videoList.width
                height: 100
                visible: videoListModel.loading
                opacity: footer.visible ? 1 : 0

                BusyDialog {
                    anchors.centerIn: footer
                    opacity: footer.opacity
                }
            }

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: ListModel {
                id: videoListModel

                property bool loading : true
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 1) && (!videoListModel.loading)) {
                    videoListModel.loading = true;
                    var pos = videoFeed.lastIndexOf("=") + 1;
                    var feed = videoFeed.slice(0, pos);
                    var page = parseInt(videoFeed.substr(pos)) + 1;
                    setVideoFeed(feed + page);
                }
            }

            delegate: XListDelegate {
                id: delegate

                checked: Scripts.indexInCheckList(index)
                onDelegateClicked: goToVideo(videoListModel.get(index))
                onPlayClicked: getVideoUrl(index)
            }

            ScrollBar {}
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
