import QtQuick 1.0
import "scripts/videoinfoscripts.js" as Scripts
import "scripts/settings.js" as Settings

Rectangle {
    id: window

    property variant video
    property string playerUrl
    property string title
    property string thumbnail
    property string duration
    property string views : "0"
    property variant tags : []

//    signal playVideo(variant video)
    signal goToVideo(variant video)
    signal search(string query, string order)

    function setVideo(videoObject) {

        toggleBusy(true);

        video = videoObject;
        thumbnail = video.thumbnail;
        duration = video.duration;

        var request = new XMLHttpRequest();
        request.onreadystatechange = function() {
            if (request.readyState == XMLHttpRequest.DONE) {
                var page = request.responseText;
                title = page.split("<title>")[1].split("<")[0];
                playerUrl = page.split("\"file\",\"")[1].split('"')[0];
                views = page.split("Views:</strong>")[1].split("<")[0];
                var tagsPart = page.split("\"KEYWORDS\" content=\"")[1].split('"')[0];
                tags = tagsPart.split(", ");

                toggleBusy(false)
            };
        }
        request.open("GET", video.link);
        request.send();
    }

    color: _BACKGROUND_COLOR

    Rectangle {
        id: dimmer

        anchors.fill: window
        color: window.color

        Rectangle {
            id: frame

            width: Math.floor(window.width / 3.2)
            height: Math.floor(frame.width / (4 / 3))
            anchors { left: dimmer.left; leftMargin: 10; top: dimmer.top; topMargin: 60 }
            color: _BACKGROUND_COLOR
            border.width: 2
            border.color: (cuteTubeTheme == "light") ? "grey" : "white"

            Image {
                id: thumb

                anchors { fill: frame; margins: 2 }
                source: thumbnail
                sourceSize.width: thumb.width
                sourceSize.height: thumb.height
                smooth: true

                Rectangle {
                    id: durationLabel

                    width: Math.floor(thumb.width / 2.5)
                    height: Math.floor(durationLabel.width / 2.5)
                    anchors { bottom: thumb.bottom; right: thumb.right }
                    color: "black"
                    opacity: 0.5

                }

                Text {
                    id: durationText

                    anchors.fill: durationLabel
                    text: duration
                    color: "white"
                    font.pixelSize: _STANDARD_FONT_SIZE
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                }

                Rectangle {
                    width: Math.floor(thumb.width / 3.5)
                    height: width
                    anchors.centerIn: thumb
                    color: frameMouseArea.pressed ? _ACTIVE_COLOR_LOW : "black"
                    opacity: 0.5
                    radius: 5
                    smooth: true

                    Image {
                        id: playIcon

                        anchors { fill: parent; margins: 5 }
                        smooth: true
                        source: "ui-images/playicon.png"
                        sourceSize.width: playIcon.width
                        sourceSize.height: playIcon.height
                    }
                }
            }

            MouseArea {
                id: frameMouseArea

                anchors.fill: frame
                onClicked: Controller.playVideo(playerUrl) /*playVideo([{ title: title,
                                      thumbnail: video.thumbnail,
                                      duration: duration,
                                      playerUrl: playerUrl }])*/
            }

            PushButton {
                id: videoButton

                width: frame.width
                anchors { left: frame.left; top: frame.bottom; topMargin: 10 }
                icon: (cuteTubeTheme == "light") ? "ui-images/videodownloadiconlight.png" : "ui-images/videodownloadicon.png"
                iconWidth: 65
                iconHeight: 65
                onButtonClicked: addDownload({ title: title,
                                    thumbnail: video.thumbnail,
                                    playerUrl: playerUrl })
            }
        }

        Item {
            id: tabItem

            anchors { fill: dimmer; leftMargin: frame.width + 20; rightMargin: 10; topMargin: 60; bottomMargin: 60 }

            Row {
                id: tabRow

                Rectangle {
                    id: infoTab

                    width: tabItem.width / 2
                    height: 40
                    color: _BACKGROUND_COLOR

                    BorderImage {
                        anchors.fill: infoTab
                        source: "ui-images/tab.png"
                        smooth: true
                        visible: tabView.currentIndex == 0
                    }

                    Text {
                        anchors.fill: infoTab
                        font.pixelSize: _STANDARD_FONT_SIZE
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: tabView.currentIndex == 0 ? _TEXT_COLOR : "grey"
                        text: qsTr("Info")
                    }

                    Rectangle {
                        height: 1
                        anchors { bottom: infoTab.bottom; left: infoTab.left; right: infoTab.right }
                        color: _ACTIVE_COLOR_HIGH
                        opacity: 0.5
                        visible: !(tabView.currentIndex == 0)
                    }

//                    MouseArea {
//                        id: infoMouseArea

//                        anchors.fill: infoTab
//                        onClicked: tabView.currentIndex = 0
//                    }
                }

                Rectangle {
                    id: relatedTab

                    width: tabItem.width / 2
                    height: 40
                    color: _BACKGROUND_COLOR

                    BorderImage {
                        anchors.fill: parent
                        source: "ui-images/tab.png"
                        smooth: true
                        visible: tabView.currentIndex == 1
                    }

                    Text {
                        anchors.fill: relatedTab
                        font.pixelSize: _STANDARD_FONT_SIZE
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: tabView.currentIndex == 1 ? _TEXT_COLOR : "grey"
                        text: qsTr("Related")
                    }

                    Rectangle {
                        height: 1
                        anchors { bottom: relatedTab.bottom; left: relatedTab.left; right: relatedTab.right }
                        color: _ACTIVE_COLOR_HIGH
                        opacity: 0.5
                        visible: !(tabView.currentIndex == 1)
                    }

//                    MouseArea {
//                        id: relatedMouseArea

//                        anchors.fill: relatedTab
//                        onClicked: tabView.currentIndex = 1
//                    }
                }
            }

            ListView {
                id: tabView

                anchors { left: tabItem.left; right: tabItem.right; top: tabRow.bottom; bottom: tabItem.bottom }
                orientation: ListView.Horizontal
                highlightMoveDuration: 200
                highlightRangeMode: ListView.StrictlyEnforceRange
                snapMode: ListView.SnapOneItem
                flickDeceleration: 500
                boundsBehavior: Flickable.StopAtBounds
                model: tabModel
                clip: true

                onCurrentIndexChanged: {
                    if ((tabView.currentIndex == 1) && (!relatedView.loaded) && (relatedView.count == 0)) {
                        relatedView.loadVideos();
                    }
                }
            }
        }

        VisualItemModel {
            id: tabModel

            Flickable {
                id: scrollArea

                width: tabView.width
                height: tabView.height
                clip: true
                contentWidth: textColumn.width
                contentHeight: textColumn.height
                flickableDirection: Flickable.VerticalFlick
                boundsBehavior: Flickable.DragOverBounds
                interactive: visibleArea.heightRatio < 1
                visible: tabView.currentIndex == 0

                Column {
                    id: textColumn

                    spacing: 10
                    width: tabView.width
                    height: childrenRect.height

                    Text {
                        id: titleText

                        width: textColumn.width
                        text: title
                        color: _TEXT_COLOR
                        font.pixelSize: _STANDARD_FONT_SIZE
                        wrapMode: TextEdit.WordWrap
                    }

                    Text {
                        font.pixelSize: _SMALL_FONT_SIZE
                        color: _TEXT_COLOR
                        text: qsTr("Views ") + "<font color=grey>" + views + "</font>"
                    }

                    Text {
                        font.pixelSize: _SMALL_FONT_SIZE
                        color: _TEXT_COLOR
                        text: qsTr("Tags")
                    }

                    Flow {
                        spacing: 10
                        width: parent.width

                        Text {
                            font.pixelSize: _SMALL_FONT_SIZE
                            color: "grey"
                            text: qsTr("No tags")
                            visible: tags.length == 0
                        }

                        Repeater {
                            model: tags

                            Text {
                                font.pixelSize: _SMALL_FONT_SIZE
                                color: children[0].pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                                text: modelData

                                MouseArea {
                                    anchors.fill: parent
                                    onClicked: search(parent.text, Settings.getSetting("searchOrder").toLowerCase())
                                }

                                Text {
                                    anchors.left: parent.right
                                    font.pixelSize: _SMALL_FONT_SIZE
                                    color: "grey"
                                    text: ","
                                    visible: index < (tags.length - 1)
                                }
                            }
                        }
                    }

                }
            }

            ListView {
                id: relatedView

                property bool loaded : false // True if related videos have been loaded
                property bool loading : false // True if related videos are loading.

                function loadVideos() {
                    relatedView.loading = true;

                    var doc = new XMLHttpRequest();
                    doc.onreadystatechange = function() {
                        if (doc.readyState == XMLHttpRequest.DONE) {
                            var results = doc.responseText.split("<a class=\"frame\" href='");
                            for (var i = 1; i < results.length; i++) {
                                var r = results[i];
                                relatedModel.append({ link: "http://youjizz.com" + r.slice(0, r.indexOf("'")),
                                                      title: r.split("id=\"title1\">\n")[1].split("<")[0],
                                                      thumbnail: r.split("<img src=\"")[1].split('"')[0],
                                                      duration: r.split("#605f5f;'>")[1].split("<")[0] });
                            }
                            relatedView.loading = false;
                            relatedView.loaded = true;
                        }
                    }
                    doc.open("GET", video.link);
                    doc.send();
                }

                function getDuration(durationString) {
                    /* Converts string to MM:SS format. */
                    var a = durationString.split("m")
                    var minutes = a[0];
                    var seconds = a[1].slice(0, -1);
                    if (seconds < 10) {
                        seconds = "0" + seconds;
                    }
                    var duration = minutes + ":" + seconds;
                    return duration;
                }

                width: tabView.width
                height: tabView.height
                boundsBehavior: Flickable.DragOverBounds
                highlightMoveDuration: 500
                preferredHighlightBegin: 0
                preferredHighlightEnd: 100
                highlightRangeMode: ListView.StrictlyEnforceRange
                cacheBuffer: 2500
                interactive: visibleArea.heightRatio < 1
                clip: true
                visible: tabView.currentIndex == 1

                model: ListModel {
                    id: relatedModel
                }

                delegate: XListDelegate {
                    id: delegate

                    onDelegateClicked: goToVideo(relatedModel.get(index))
                }

                ScrollBar {}

                BusyDialog {
                    anchors.centerIn: relatedView
                    opacity: (tabView.currentIndex == 1 && relatedView.loading)
                }
            }
        }

        MouseArea {
            id: mouseArea

            anchors.fill: dimmer
            enabled: false
            onClicked: Scripts.closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
        PropertyChanges { target: frame; width: Math.floor(window.width / 1.9) }
        PropertyChanges { target: tabItem; anchors { leftMargin: 10; rightMargin: 10; topMargin: frame.height + 70 } }
        AnchorChanges { target: videoButton; anchors { left: frame.right; top: frame.top } }
        PropertyChanges { target: videoButton; anchors.leftMargin: 10; anchors.topMargin: 0; width: window.width - (frame.width + 30); }
    }
}

