import QtQuick 1.0
import "videolistscripts.js" as Scripts
import "menu.js" as Menu

Rectangle {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
    //signal playVideos(variant videos)

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var results = doc.responseText.split("<a class=\"frame\" href='");
                for (var i = 1; i < results.length; i++) {
                    var r = results[i];
                    videoListModel.append({ link: "http://youjizz.com" + r.slice(0, r.indexOf("'")),
                                          title: r.split("id=\"title1\">\n")[1].split("<")[0],
                                          thumbnail: r.split("<img src=\"")[1].split('"')[0],
                                          duration: r.split("#605f5f;'>")[1].split("<")[0] });
                }
                videoListModel.loading = false;
            }
        }
        doc.open("GET", feed);
        doc.send();
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    function showVideoDialog() {
        if (dialog.source == "") {
            toggleBusy(true);

            dimmer.state = "dim";
            dialog.source = "VideoListDialog.qml";
            var video = videoListModel.get(videoList.currentIndex);
            dialog.item.infoClicked.connect(goToVideo);
            dialog.item.playClicked.connect(playVideo);
            dialog.item.close.connect(Scripts.closeDialogs);
            videoList.interactive = false;
            mouseArea.enabled = true;

            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == XMLHttpRequest.DONE) {
                    var page = request.responseText;
                    video["title"] = page.split("<title>")[2].split("<")[0];
                    video["playerUrl"] = page.split("\"file\",\"")[1].split('"')[0];

                    toggleBusy(false);

                    dialog.item.setVideo(video);
                }
            }
            request.open("GET", video.link);
            request.send();
        }
    }

    function addVideosToDownloads() {

        toggleBusy(true);

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = videoListModel.get(videoList.checkList[i])
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == XMLHttpRequest.DONE) {
                    var page = request.responseText;
                    var title = page.split("<title>")[2].split("<")[0];
                    var playerUrl = page.split("\"file\",\"")[1].split('"')[0];

                    addDownload({ title: title,
                                thumbnail: video.thumbnail,
                                playerUrl: playerUrl });

                    toggleBusy(false);
                }
            }
            request.open("GET", video.link);
            request.send();
        }
        videoList.checkList = [];
    }

    function playVideo(playerUrl) {
        Controller.playVideo(playerUrl);
    }

    color: "black"
    onStateChanged: Scripts.rotateDialogs()

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Loader {
            id: menuLoader

            property bool pencilOn : false

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                menuLoader.item.addMenuItems([ { name: qsTr("Multi-select") } ]);
                if (menuLoader.pencilOn) {
                    menuLoader.item.addMenuItems([ { name: qsTr("Download video") } ])
                }
            }

            onPencilOnChanged: menuLoader.item.pencilOn = menuLoader.pencilOn

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        videoList.checkList = [];
                    }
                    else if (index == 1) {
                        addVideosToDownloads();
                    }
                    menuLoader.pencilOn = !menuLoader.pencilOn;
                }
            }
        }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: largeFontSize
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No videos found")
            visible: (!videoListModel.loading) && (videoList.count == 0)
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: dimmer.state == "" ? ListView.StrictlyEnforceRange : ListView.NoHighlightRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            footer: Rectangle {
                id: footer
                width: videoList.width
                height: 100
                color: "black"
                visible: videoListModel.loading
                opacity: footer.visible ? 1 : 0

                BusyDialog {
                    anchors.centerIn: footer
                    opacity: footer.opacity
                }
            }

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: ListModel {
                id: videoListModel

                property bool loading : true
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 15) && (!videoListModel.loading)) {
                    videoListModel.loading = true;
                    var split = videoFeed.lastIndexOf("-") + 1;
                    var feed = videoFeed.slice(0, split);
                    var page = parseInt(videoFeed.slice(split, videoFeed.lastIndexOf("."))) + 1;
                    setVideoFeed(feed + page + ".html");
                }
            }

            delegate: XXXListDelegate {
                id: delegate

                function checkOrGoToVideo() {
                    if (menuLoader.pencilOn) {
                        var cl = videoList.checkList;
                        if (!delegate.checked) {
                            cl.push(index);
                        }
                        else {
                            for (var i = 0; i < cl.length; i++) {
                                if (cl[i] == index) {
                                    cl.splice(i, 1);
                                }
                            }
                        }
                        videoList.checkList = cl;
                    }
                    else {
                        goToVideo(videoListModel.get(index));
                    }
                }

                checked: Scripts.indexInCheckList(index)

                Connections {
                    onDelegateClicked: checkOrGoToVideo()
                    onDelegatePressed: {
                        videoList.currentIndex = index;
                        showVideoDialog();
                    }
                }
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
            onClicked: Scripts.closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
