#!/bin/bash

if [ $(basename $(pwd)) = "debian" ]; then
    echo "This script must be called from the top level source directory" >&2
    exit 1
fi

CONTROL="debian/control"
PKG=$(grep ^Package: ${CONTROL}|head -n 1|cut -d: -f 2|tr -d ' ')
PKGNAME=$(grep AC_INIT configure.in |cut -d [ -f 2|cut -d ] -f 1)

eval $(grep ALL_LINGUAS configure.in)

for l in ${ALL_LINGUAS}
do
    pl=$(echo ${l} | sed s:_:-:| tr [:upper:] [:lower:])
    if grep ${PKG}-locale-${pl} ${CONTROL} > /dev/null 2>/dev/null; then
        continue
    fi
    echo >> ${CONTROL}
    echo "Package: $PKG-locale-$pl" >> ${CONTROL}
    echo "Architecture: any" >> ${CONTROL}
    echo "Depends: ${PKG}"' (=  ${Source-Version})' >> ${CONTROL}
    echo "Description: ${l} locale for ${PKGNAME}" >> ${CONTROL}

    echo "usr/share/locale/${l}" > debian/${PKG}-locale-${pl}.install
done
