from PyQt4 import uic
from PyQt4.QtCore import *
from xbmcpotatolib import *
import tools_dialog
from PyQt4.QtGui import * 
from PyQt4 import QtCore
from PyQt4.QtCore import QEvent
import simplejson
import copy
from copy import deepcopy
import XBMCMessageClass
import threading
import time
import traceback
from xpot_config import *
from avr import YamahaRXVClient
from time import sleep
import socket
from telnetlib import Telnet
import operator
import random
from decimal import *

class TrackChangedEvent(QEvent):
	def __init__(self, ix):
		QEvent.__init__(self, QEvent.User+0)
		self.ix = ix
		
	def setCurrentSongIndex(self, ix):
		self.ix = ix
	
	def getCurrentSongIndex(self):
		return self.ix
	

class CurrentSongThread ( QThread ):
	def __init__(self,xbmc,gui):
		QThread.__init__(self)
		self.xbmc = xbmc
		self.gui = gui
		self.abort = False
		self.playerStopped = False
		self.currentSongIx = -1
		self.playerState = -1
		
	def run (self):
		while self.abort == False:
			if self.playerStopped == False:
				self.getCurrentSong()
			time.sleep(1)
		
	def abortThread(self):
		self.abort = True
		
	def getCurrentSong(self):
		res = self.xbmc.getCurrentSong()
		try:
			self.event = TrackChangedEvent('-1')			
			self.event.setCurrentSongIndex(res.MResult)
			if type(res.MResult) is int:
				if self.currentSongIx <> res.MResult:
					self.currentSongIx = res.MResult
					qApp.postEvent(self.gui,self.event)
		except:
			print "Exception: Failed to get Current Song"	
			traceback.print_exc(None, None)
		
		playerState = self.xbmc.getAudioPlayerState()
		try:
			if 'playing' in playerState.MResult:
				if self.playerState <> playerState.MResult['playing']:
					self.playerState = playerState.MResult['playing']
					self.event = TrackChangedEvent('-1')			
					self.event.setCurrentSongIndex(res.MResult)					
					qApp.postEvent(self.gui,self.event)
			else:
				if self.playerState <> playerState.MResult:
					self.playerState = playerState.MResult
					self.event = TrackChangedEvent('-1')			
					self.event.setCurrentSongIndex(res.MResult)						
					qApp.postEvent(self.gui,self.event)
		except:
			print "Exception: Failed to get/set current player state"	
			traceback.print_exc(None, None)					
				
			
			



(Ui_XPotMainWindow, QMainWindow) = uic.loadUiType('xpot_mainwindow.ui')
class XPotMainWindow (QMainWindow):
	"""XPotMainWindow inherits QMainWindow"""
	def __init__ (self, parent = None):
		self.version = "0.5"
		self.name = "XBMC Potato"
		self.developer = "Yiannis Petevis"
		self.email = "y.petevis@gmail.com"
		QMainWindow.__init__(self, parent)
		self.setWindowTitle(self.name)
		self.directoryClicked = False
		self.randomize = False
		self.randomizeCap = 50
		self.navButtonDic = {}
		
		self.progressCancelButton = QPushButton("Cancel")
		self.progDialogAdd = QProgressDialog(self)
		self.progDialogAdd.setCancelButton(self.progressCancelButton)
		self.progDialogAdd.setAutoReset(True)
		self.progDialogAdd.setAutoClose(True)
		self.progDialogAdd.setMinimum(0)
		self.progDialogAdd.setMaximum(100)
		self.progDialogAdd.setWindowModality(QtCore.Qt.WindowModal)
		self.progDialogAddCancelled = False
		
		self.progDialog = QProgressDialog(self)
		self.progDialog.setAutoReset(True)
		self.progDialog.setAutoClose(True)
		self.progDialog.setMinimum(0)
		self.progDialog.setMaximum(100)
		self.progDialog.setWindowModality(QtCore.Qt.WindowModal)
		self.progDialog.setCancelButton(None)
		self.progDialog.show()
		self.progDialog.setWindowTitle("Starting Up...")		
		self.progDialog.setValue(10)			
		self.showFullScreen()
		self.fullScreen = True	
		self.ui = Ui_XPotMainWindow()
		self.ui.setupUi(self)
		self.config = XPotConfig(None)
		self.ui.treeWidget.setStyleSheet("QTreeWidget::indicator:checked { image: url(:/img/checkbox_checked26.png); } QTreeWidget::indicator:unchecked { image: url(:/img/checkbox_unchecked26.png); }")
		self.ui.treeWidget.setColumnCount(1)
		self.mapper = QSignalMapper(self)
		self.mapper.mapped[str].connect(self.navButtonclick)
		self.signalWiring()
		self.xbmc = XBMCLib(self.config.server, self.config.port, self.config.user, self.config.password)			
		if self.config.server == "":
			self.progDialog.setValue(100)	
			self.showMessage("XBMC Potato has not been configured yet.  Click OK to configure now and restart the application.")
			self.showToolsDialog()
			return

		start = time.time()
		while self.isXBMCPoweredOn() == False:
			if self.config.powerOnXBMC == 'True':
				self.progDialog.setWindowTitle("Powering On XBMC")		
				self.progDialog.setValue(20)							
				self.XBMCWakeOnLan()
				sleep(5)
			else:
				self.progDialog.setWindowTitle("Waiting for XBMC to respond...")		
				self.progDialog.setValue(20)				
				self.config.powerOnXBMCTimeout = 2
			end = time.time()
			elapsed = end - start
			if elapsed >= int(self.config.powerOnXBMCTimeout):
				break

		self.currentSongIx = -1		
		if self.isXBMCPoweredOn():
			self.progDialog.setWindowTitle("Retrieving Media Shares")		
			self.progDialog.setValue(30)			
			self.getMusicShareDirectories()
			self.progDialog.setWindowTitle("Reading Current Playlist")		
			self.progDialog.setValue(50)					
			self.getCurrentPlaylistItems()
			self.initializeNavButtons()
			self.currentSongThread = CurrentSongThread(self.xbmc,self)
			self.currentSongThread.start()
			self.setPlayButtonState()		
			trademark = QLabel()
			font = QFont()
			font.setBold(True)
			font.setItalic(True)
			font.setPointSize(9)
			trademark.setFont(font)
			trademark.setText('<font color="#4863A0">//Coded by Yiannis Petevis</font>')
			self.installEventFilter(self)
			self.initializeAVR()
			self.progDialog.setValue(100)		
		else:
			self.progDialog.setValue(100)
			self.showMessage("Connection to XBMC failed")

	def isXBMCPoweredOn(self):
		s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		s.settimeout(0.5)
		try:
			s.connect((self.config.server, int(self.config.port)))
			s.shutdown(2)
			return True
		except:
			return False
		
	def XBMCWakeOnLan(self):
		s=socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
		s.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
		ip_array = self.config.server.split(".")
		ip_array.pop(3)
		dot = "."
		ip_head = dot.join(ip_array)
		mac_hex = self.config.XBMCMac.decode("hex")
		ip_broadcast = ip_head + ".255"
		s.sendto("\xff"*6+mac_hex*16, (ip_broadcast, 9) )

	
	def initializeAVR(self):
		self.avr = YamahaRXVClient.YamahaRXVClient(self.config.serverAVR, int(self.config.portAVR))
		if self.config.powerOnAVR == 'True':
			self.progDialog.setWindowTitle("Powering On AV Receiver")		
			self.progDialog.setValue(70)			
			self.avr.powerOn()
		if self.config.switchSourceAVR == 'True':
			self.progDialog.setWindowTitle("Switching AV Receiver Source")		
			self.progDialog.setValue(90)			
			sleep(0.5)
			self.switchAVRSource()
			self.progDialog.setWindowTitle("Switching AV Receiver Source")		
	
	def switchAVRSource(self):
		switchSourceMethodName = "input%s" % self.config.sourceAVR
		switchSource = getattr(self.avr, switchSourceMethodName)
		switchSource()		
	
	def markCurrentSong(self, ix):
		try:
			if type(ix) is int:
				if self.currentSongIx <> ix:
					self.setPlayButtonState()
					self.currentSongIx = ix
					x = 0
					while x <  self.ui.treeWidgetPlaylist.topLevelItemCount():
						if x <> ix:
							color = QColor("gray")
						else:
							color = QColor()
							color.setNamedColor("#FF6600")
							self.ui.treeWidgetPlaylist.scrollToItem(self.ui.treeWidgetPlaylist.topLevelItem(x),hint=QAbstractItemView.PositionAtCenter)
						brush = QBrush()
						brush.setColor(color)
						self.ui.treeWidgetPlaylist.topLevelItem(x).setForeground(0,brush)
#						print self.ui.treeWidgetPlaylist.topLevelItem(x).text(1)
#						self.xbmc.setConnectionParameters(self.config.server, '8080', "", "")
#						self.xbmc.introspect()
#						self.xbmc.setConnectionParameters(self.config.server, '8080', "", "")
#						self.xbmc.getFanArt(self.ui.treeWidgetPlaylist.topLevelItem(x).text(1))
#						self.xbmc.setConnectionParameters(self.config.server, '9090', "", "")
						x += 1
			else:
				self.setPlayButtonState()
		except:
			print "Failed to set Current Song"
			self.setPlayButtonState()
			traceback.print_exc()
		if self.currentSongIx < 0:
			csong = "";
		else:
			csong = self.currentSongIx + 1
		self.ui.labelPlaylistCurrentTrack.setText("Track %s" % str(csong))
	
	def initializeNavButtons(self):
		if self.ui.navLayout.count() == 0:
			rootButton = QPushButton()
			rootButton.setIcon(QIcon(":/img/user-home.png"))
			rootButton.setCheckable(True)
			rootButton.setIconSize(QSize(32,32))
			self.ui.navLayout.addWidget(rootButton,0)
			rootButton.clicked.connect(self.mapper.map)
			self.mapper.setMapping(rootButton, "|GOTO_SHARES_ROOT")
	
	def getCurrentPlaylistItems(self):
		itemsList = []
		playlist_length = self.ui.treeWidgetPlaylist.topLevelItemCount()
		items = self.xbmc.getPlaylistItems()
		self.ui.treeWidgetPlaylist.setIconSize(QSize(48,48))
		if items.MType == 'S':
			for item in items.MResult:
				item1 = QTreeWidgetItem()
				if "thumbnail" in item:
					print "Found"
					u = "http://" + self.config.server + ":8080/vfs/" + item["thumbnail"]
					f = self.xbmc.downloadImage(u)
					ic = QIcon(f)
					print u
					item1.setIcon(0,ic)
				else:
					ic = QIcon(":/img//music.png")
					item1.setIcon(0,ic)
				item1.setText(0, item["label"])
				item1.setText(1, item["file"])
				item1.setText(2, item["file"])
				
				
				itemsList.append(item1)
			ix = playlist_length + 1
			self.ui.treeWidgetPlaylist.insertTopLevelItems(ix, itemsList)
			self.ui.treeWidgetPlaylist.setColumnCount(1)
		else:
			print items.MText
		self.ui.labelPlaylistTotalTracks.setText("%s Tracks" % str(self.ui.treeWidgetPlaylist.topLevelItemCount()))
		
	def signalWiring(self):
		self.ui.pushButtonAdd.clicked.connect(self.addSelectedSongs)
		self.ui.pushButtonAddAll.clicked.connect(self.addAllSongs)
		self.ui.pushButtonRandomize.clicked.connect(self.addRandomSongs)
		self.ui.pushButtonPlay.clicked.connect(self.playSongs)
		self.ui.pushButtonStop.clicked.connect(self.stopPlaying)
		self.ui.pushButtonClear.clicked.connect(self.clearPlaylist)
		self.ui.pushButtonSkipNext.clicked.connect(self.skipNext)
		self.ui.pushButtonSkipPrevious.clicked.connect(self.skipPrevious)
		self.ui.pushButtonShuffle.toggled.connect(self.shuffle)
		self.ui.treeWidget.itemChanged.connect(self.clickDirectory)
		self.ui.treeWidget.itemClicked.connect(self.click)
		self.ui.pushButtonFullScreenToggle.clicked.connect(self.toggleFullScreen)
		self.ui.pushButtonTools.clicked.connect(self.showToolsDialog)
		self.ui.pushButtonVolUp.pressed.connect(self.volumeUp)
		self.ui.pushButtonVolUp.released.connect(self.volumeUpStop)
		self.ui.pushButtonVolDown.pressed.connect(self.volumeDown)
		self.ui.pushButtonVolDown.released.connect(self.volumeDownStop)
		self.progDialogAdd.canceled.connect(self.cancelProgressDialog)
	

	def __del__ (self):
		self.ui = None

	def getMusicShareDirectories(self):
		self.ui.treeWidget.clear()
		shares=self.xbmc.getMusicSources()
		if shares.MType == 'S':
			for item in shares.MResult:
				msobject = self.xbmc.getMusicSourceObjects(item['file'])
				if "directories" in msobject.MResult:
					self.addNavigatorRows(msobject, "directories")
				if "files" in msobject.MResult:
					self.addNavigatorRows(msobject, "files")
		else:
			print shares.MText	

	def addNavigatorRows(self, msobject, type):
		for item in msobject.MResult[type]:
			item1 = QTreeWidgetItem()
			item1.setText(0, item["label"])
			item1.setText(1, item["file"])
			item1.setText(2, type)
			
			if type == "files":
				item1.setFlags(Qt.ItemIsEnabled|Qt.ItemIsSelectable)
				item1.setCheckState(0,Qt.Unchecked);
			else:
				item1.setFlags(Qt.ItemIsUserCheckable|Qt.ItemIsEnabled|Qt.ItemIsSelectable)
				item1.setCheckState(0,Qt.Unchecked);
			self.ui.treeWidget.addTopLevelItem(item1)

	def getDirectory(self, dir, positionIx):
		msobject = self.xbmc.getMusicSourceObjects(dir)
		if msobject.MType == 'S':
			self.ui.treeWidget.clear()
			if "directories" in msobject.MResult:
				self.addNavigatorRows(msobject, "directories")
				self.ui.treeWidget.setSelectionMode(QAbstractItemView.SingleSelection)				
			if "files" in msobject.MResult:
				self.addNavigatorRows(msobject, "files")
				self.ui.treeWidget.setSelectionMode(QAbstractItemView.SingleSelection) 
			self.ui.treeWidget.sortItems(0,Qt.AscendingOrder)
			self.ui.treeWidget.scrollToItem(self.ui.treeWidget.topLevelItem(int(positionIx)),hint=QAbstractItemView.PositionAtTop)

	
	def setPlayButtonState(self):
		exception = False
		try:
			playing = self.xbmc.getAudioPlayerState().MResult["playing"]
			paused = self.xbmc.getAudioPlayerState().MResult["paused"]
		except:
			playing = False
			paused = False
			exception = True
		if playing == True and paused == False:
			self.ui.pushButtonPlay.setIcon(QIcon(":/img//media-playback-pause.png"))
			self.ui.pushButtonPlay.setProperty("Paused",False)
			self.currentSongThread.playerStopped = False
		else:
			self.ui.pushButtonPlay.setIcon(QIcon(":/img//media-playback-start.png"))
			self.ui.pushButtonPlay.setProperty("Paused",True)
			if exception == False:
				self.currentSongThread.playerStopped = True
		if playing == False:
			return True
		else:
			return False


	def increaseVolumeThread(self):
		while self.increaseVolume:
			if self.config.volumeControl == 'AVR':			
				self.avr.volumeUp()
			else:
				self.xbmc.volumeUp()
			sleep(0.1)
	
	def decreaseVolumeThread(self):
		while self.decreaseVolume:
			if self.config.volumeControl == 'AVR':
				self.avr.volumeDown()
			else:
				self.xbmc.volumeDown()
			sleep(0.1)				

	def showMessage(self, message):
		if message.find("Extra data") == -1: #Ignore JSONDecodeError -- Extra Data message
			nmessage = message + "\nVerify that XBMC is switched on, accepting connections and accessible over this network connection."
			QMessageBox.warning(self,'Warning', nmessage, buttons=QMessageBox.Ok, defaultButton=QMessageBox.NoButton)
		else:
			print message


##################################################################################
#
#  Event handlers for Signals
#
##################################################################################
	def volumeUp(self):
		self.increaseVolume = True
		volumeThread = threading.Thread(None, self.increaseVolumeThread)
		volumeThread.start()		

	def volumeUpStop(self):
		self.increaseVolume = False
		
	def volumeDown(self):
		self.decreaseVolume = True
		volumeThread = threading.Thread(None, self.decreaseVolumeThread)
		volumeThread.start()		
					
	def volumeDownStop(self):
		self.decreaseVolume = False				

	def eventFilter(self,object,event):
		if event.type() == QEvent.User+0:
			self.markCurrentSong(event.getCurrentSongIndex())
			return True
		return False

	def clickDirectory(self, item):
		if item.text(2) == "directories":
			self.directoryClicked = True
		else:
			self.directoryClicked = False
			

	def click(self):
		if self.directoryClicked:
			self.directoryClicked = False
			return
		try:
			items = self.ui.treeWidget.selectedItems()
			dir = items[0].text(1)
			dirlabel = items[0].text(0)
			removeNext = False
			if self.ui.navLayout.count() == 0:
				rootButton = QPushButton("//")
				rootButton.setCheckable(True)
				self.ui.navLayout.addWidget(rootButton,0)
				rootButton.clicked.connect(self.mapper.map)
				self.mapper.setMapping(rootButton, "//|GOTO_SHARES_ROOT")
	
			if items[0].text(2) == "directories":
				ix = 0
				buttonCount = self.ui.navLayout.count()
				buttons = []
				while ix < buttonCount:
					button = self.ui.navLayout.itemAt(ix).widget()
					if removeNext == True:
						buttons.append(button)		
					if button.isChecked():
						removeNext = True
						button.setChecked(False)
						self.navButtonDic[button.text()] = self.ui.treeWidget.selectedIndexes()[0].row()
					ix = ix + 1
						
				for but in buttons:
					self.ui.navLayout.removeWidget(but)
					if but is not None:
						but.deleteLater()
	
				dirButton = QPushButton(dirlabel)
				dirButton.setCheckable(True)
				dirButton.setChecked(True)
				dirButton.clicked.connect(self.mapper.map)
				self.mapper.setMapping(dirButton, items[0].text(0) + "|" + items[0].text(1))
				self.ui.navLayout.addWidget(dirButton,0)
				self.getDirectory(dir, -1)
			elif items[0].text(2) == "files":
				if items[0].checkState(0) == Qt.Checked:
					items[0].setCheckState(0, Qt.Unchecked)
				elif items[0].checkState(0) == Qt.Unchecked:
					items[0].setCheckState(0, Qt.Checked)
		except Exception, e:
			traceback.print_exc(None, None)

		
	def navButtonclick(self,label_dir):
		ldlist = label_dir.split("|")
		ix = 0
		buttonCount = self.ui.navLayout.count()	
		while ix < buttonCount:
			button = self.ui.navLayout.itemAt(ix).widget()		
			if ldlist[0] == button.text():
				button.setChecked(True)
			else:
				button.setChecked(False)
			ix = ix + 1
		if ldlist[1] == "GOTO_SHARES_ROOT":
			self.getMusicShareDirectories()
		else:
			if ldlist[0] in self.navButtonDic:
				self.getDirectory(ldlist[1], self.navButtonDic[ldlist[0]])
			else:
				self.getDirectory(ldlist[1], -1)

		
	def addSelectedSongs(self):
		self.progDialogAddCancelled = False
		self.showProgress("Scanning Music Folders...", 0)
		self.showProgress("Scanning Music Folders...", 5)
		sleep(0.5)
		self.showProgress("Scanning Music Folders...", 10)
		
		self.trackBuffer = []
		self.ui.treeWidgetPlaylist.setColumnCount(1)
		itemsList = []
		playlist_length = self.ui.treeWidgetPlaylist.topLevelItemCount()
		ic = 0
		while ic < self.ui.treeWidget.topLevelItemCount() and self.progDialogAddCancelled == False:
			item = self.ui.treeWidget.topLevelItem(ic)
			if item.text(2) == "files" and item.checkState(0) == Qt.Checked:
				item.setCheckState(0,Qt.Unchecked)
				item1 = QTreeWidgetItem()
				item1.setText(0, item.text(0))
				item1.setText(1, item.text(1))
				item1.setText(2, item.text(2))

				itemsList.append(item1)
			if item.text(2) == "directories" and item.checkState(0) == Qt.Checked:
				item.setCheckState(0,Qt.Unchecked)
				self.addSongsInDirectory(item.text(1))
			ic = ic + 1

		for itm in itemsList:
			self.trackBuffer.append(itm.text(1))

		track_count = self.trackBuffer.__len__()
		
		if self.randomize == True and self.progDialogAddCancelled == False:
			self.showProgress("Shuffling Tracks...", 40)
			cap = self.randomizeCap
			if track_count < self.randomizeCap:
				cap = track_count
			if track_count > 0:
				self.trackBuffer = random.sample(self.trackBuffer,cap)
		
		track_count = self.trackBuffer.__len__()
						
		if self.progDialogAddCancelled == False:
			self.showProgress("Adding %s Tracks to Playlist..." % str(track_count), 0)
		if track_count > 0:
			scale = Decimal(100) / Decimal(track_count)
		progress = 0
		for track in self.trackBuffer:	
			if self.progDialogAddCancelled == True:
				break		                                                                                                                                                                         
			item2 = QTreeWidgetItem()
			item2.setText(1, track)
			res=self.xbmc.addSong(track)
			itemsList.append(item2)
			progress = progress + scale
			self.showProgress("Adding %s Tracks to Playlist..." % str(track_count), progress)
		
		if progress < 100:
			self.progDialogAdd.setValue(100)

		ix = playlist_length + 1
		self.ui.treeWidgetPlaylist.insertTopLevelItems(ix, itemsList)
		self.ui.treeWidget.clearSelection()
		self.shuffle()
		self.currentSongIx = -1
		self.randomize = False
		self.ui.labelPlaylistTotalTracks.setText("%s Tracks" % str(self.ui.treeWidgetPlaylist.topLevelItemCount()))
		
	def showProgress(self, title, progress):
		if self.progDialogAddCancelled == False:
			self.progDialogAdd.setWindowTitle(title)
			self.progDialogAdd.setValue(progress)
		
	def cancelProgressDialog(self):
		self.progDialogAdd.setValue(100)
		self.progDialogAddCancelled = True
		
		
	def addRandomSongs(self):
		ic = 0
		while ic < self.ui.treeWidget.topLevelItemCount():
			item = self.ui.treeWidget.topLevelItem(ic)
			if item.checkState(0) == Qt.Checked:		
				self.randomize = True
				self.randomizeCap, ok = QInputDialog.getInteger(self, "Shuffle", "Maximum Tracks", value=self.randomizeCap, min=5, max=2147483647, step=5)
				if ok:
					self.addSelectedSongs()
				else:
					self.randomize = False
				break
			ic = ic + 1
		
	
	def addSongsInDirectory(self, item):
		msobject = self.xbmc.getMusicSourceObjects(item)
		if msobject.MType == 'S':
			if 'directories' in msobject.MResult:
				for itm in msobject.MResult["directories"]:
					if self.progDialogAddCancelled:
						return
					self.showProgress("Scanning Music Folders...", 0)
					self.addSongsInDirectory(itm['file'])
					self.progDialogAdd.setValue(99)
			elif 'files' in msobject.MResult:
				file_count = msobject.MResult["files"].__len__()
				scale = 99
				progress = 0
				if file_count > 0:
					scale = 99 / file_count
				for itm in sorted(msobject.MResult["files"], key=operator.itemgetter('file')):
					if self.progDialogAddCancelled:
						return
					self.showProgress("Retrieving Music Tracks...", progress)
					self.trackBuffer.append(itm['file'])
					progress = progress + scale
		else:
			self.showMessage(msobject.MText)
					

	def addAllSongs(self):
		self.ui.treeWidgetPlaylist.setColumnCount(1)
		itemsList = []
		playlist_length = self.ui.treeWidgetPlaylist.topLevelItemCount()
		ic = 0
		while ic < self.ui.treeWidget.topLevelItemCount():
			item = self.ui.treeWidget.topLevelItem(ic)
			if item.text(2) == "files":
				item.setCheckState(0,Qt.Unchecked)
				item1 = QTreeWidgetItem()
				item1.setText(0, item.text(0))
				item1.setText(1, item.text(1))
				item1.setText(2, item.text(2))
				res=self.xbmc.addSong(item.text(1))
				if res.MType == 'S':
					itemsList.append(item1)
				else:
					print res.MText
			ic = ic + 1
		ix = playlist_length + 1
		self.ui.treeWidgetPlaylist.insertTopLevelItems(ix, itemsList)
		self.ui.treeWidget.clearSelection()
		self.shuffle()
		self.currentSongIx = -1
		self.ui.labelPlaylistTotalTracks.setText("%s Tracks" % str(self.ui.treeWidgetPlaylist.topLevelItemCount()))

	def clearPlaylist(self):
		res = self.xbmc.clearPlaylist()
		if res.MType != 'S':
			print res.MText
			self.showMessage(res.MText)
		self.ui.treeWidgetPlaylist.clear()
		self.getCurrentPlaylistItems()					
					
	def playSongs(self):
		stopped = self.setPlayButtonState()
		if stopped:
			res = self.xbmc.play()
		else:
			res = self.xbmc.pause()
		if res.MType != 'S':
			print res.MText
			self.showMessage(res.MText)
		self.setPlayButtonState()
			
	def stopPlaying(self):
		res = self.xbmc.stop()
		if res.MType != 'S':
			print res.MText
			self.showMessage(res.MText)
		self.setPlayButtonState()	
					

	def skipNext(self):
		res = self.xbmc.skipNext()
		if res.MType != 'S':
			print res.MText
			self.showMessage(res.MText)
		self.setPlayButtonState()			

	def skipPrevious(self):
		res = self.xbmc.skipPrevious()
		if res.MType != 'S':
			print res.MText
			self.showMessage(res.MText)
		self.setPlayButtonState()
			
	def shuffle(self):
		if self.ui.pushButtonShuffle.isChecked():
			res = self.xbmc.shuffle()			
		else:
			res = self.xbmc.unShuffle()
		if res.MType != 'S':
			print res.MText
			self.showMessage(res.MText)
		self.ui.treeWidgetPlaylist.clear()
		self.getCurrentPlaylistItems()	
		
	def toggleFullScreen(self):
		if self.fullScreen:
			self.fullScreen = False			
			self.showNormal()
			#self.setWindowModality(QtCore.Qt.WindowModal)
		else:
			self.fullScreen = True					
			self.showFullScreen()
			#self.setWindowModality(QtCore.Qt.WindowModal)	
			
	def showToolsDialog(self):
		toolsDialog = tools_dialog.XPotToolsDialog(self)
		toolsDialog.ui.labelNameVersion.setText( "%s %s" % (self.name, self.version) )
		toolsDialog.ui.labelDeveloper.setText( "by %s" % self.developer )
		toolsDialog.ui.labelEmail.setText( self.email )
		a = toolsDialog.exec_()
		if a == 1:
			self.config = toolsDialog.config
			toolsDialog.updateConfig()
			self.xbmc.setConnectionParameters(self.config.server, self.config.port, self.config.user, self.config.password)

