'''
Created on 4 Dec 2010

@author: yiannis
'''

import socket
import traceback
from time import sleep

class YamahaRXVClient(object):
    '''
    classdocs
    '''

    def __init__(self, server, port):
        self.server = server
        self.port = port
        
    def connect(self):
        self.clientSocket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
        self.clientSocket.settimeout(5)
        try:
            self.clientSocket.connect((self.server, self.port))
        except Exception, e:
            traceback.print_exc(None, None)
        
    def test(self):
        self.connect()
        try:     
            self.clientSocket.send ( 'TEST_COMMAND' )
            print self.clientSocket.recv(100)
        except Exception,e:
            traceback.print_exc(None, None)
    
    def stopServer(self):
        self.connect()
        try:
            self.clientSocket.send ( 'STOP_SERVER' )
            print self.clientSocket.recv(100)
        except Exception,e:
            traceback.print_exc(None, None)        
        
    def powerOff(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x45\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            
        
    def powerOn(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x44\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            
        
    def volumeUp(self):
        self.connect()
        self.clientSocket.send( '\x02\x30\x37\x41\x31\x41\x03' )

    def volumeDown(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x42\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            

    def volumeMuteOn(self):
        self.connect()
        self.clientSocket.send( '\x02\x30\x37\x45\x41\x32\x03' )

    def volumeMuteOff(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x45\x41\x33\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            

###########################

    def inputPHONO(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x34\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            

    def inputCD(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x35\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            

    def inputTUNER(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x36\x03' )
        except Exception,e:
            traceback.print_exc(None, None)            

    def inputCDR(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x39\x03' )
        except Exception,e:
            traceback.print_exc(None, None)                    


    def inputMD_TAPE(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x43\x39\x03' )
        except Exception,e:
            traceback.print_exc(None, None)                    


    def inputDVD(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x43\x31\x03' )
        except Exception,e:
            traceback.print_exc(None, None)                    


    def inputDTV_LD(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x35\x34\x03' )
        except Exception,e:
            traceback.print_exc(None, None)                    


    def inputCBL_SAT(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x43\x30\x03' )        
        except Exception,e:
            traceback.print_exc(None, None)

    def inputVCR1(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x30\x46\x03' )        
        except Exception,e:
            traceback.print_exc(None, None)

    def inputVCR2_DVR(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x31\x33\x03' )        
        except Exception,e:
            traceback.print_exc(None, None)

    def inputVAUX(self):
        self.connect()
        try:
            self.clientSocket.send( '\x02\x30\x37\x41\x35\x35\x03' )        
        except Exception,e:
            traceback.print_exc(None, None)               
#########################

        
    def disconnect(self):
        self.clientSocket.close()
        
        
if __name__ == '__main__':
    yamahaClient = YamahaRXVClient('192.168.2.42',9898)
    yamahaClient.powerOff()
    yamahaClient.disconnect()
          
        