#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys, re, mechanize, base64, urllib2, time, calendar, urllib, sqlite3
from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QApplication, QDialog, QImage, QPixmap
from www2sms_gui_dialog_captcha import Ui_DialogCaptcha

def UpdatePbar(self, MainWindow, app, value, label):
	MainWindow.Stat.ui.label.setText(label)
	MainWindow.Stat.ui.progressBar.setProperty("value", value)
	app.processEvents()

class ShowCAPTCHA(QDialog, Ui_DialogCaptcha):
	def __init__(self, win_parent = None):
		#Init the base class
		QDialog.__init__(self, win_parent)
		self.ui = Ui_DialogCaptcha()
		self.ui.setupUi(self)

def error(self, MainWindow, exception, user_msg):
	# Just for error handling stuff.
	# When this module exits with "True" the user will see a notification with user_msg
	# If this module exits with anything but "True" the user will see a warning with user_msg
	MainWindow.Stat.close()
	return exception, user_msg

# Class which holds the provider methods.
class provider():
	# get the printable name for this provider
	def getName(self):
		raise Exception('provider class is a base class only')
	# eventually we will have to separate the advanced features out, and return these as
	# canSchedule(), canSetSender(), canFlash(), but with the current providers these
	# are all either on or off, so we use a single method to describe them
	def hasAdvancedFeatures(self):
		return False
	# Define the number of characters we can use per SMS.
	# 160 is the default SMS length, some providers might strip it down to add some advert.
	# Second argument should be the maximum Length of a message.
	def chars_per_sms(self):
		return 160, 160
	# Specify a regex to test the entered recipient number against and a not you'll like
	# to show to the user
	# Per default we accept everything that looks like this: +{AnyNumber}
	def num_regexp(self, num):
	    	return False, num, 'This is a reply from base class... something went wrong'
	# send the sms
	def sendSMS(self, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
		return False, "SMS sending not implemented"

# o2online.de 2.3
# o2online (DE) Provider written by Bjoern Olausson <maemo@olausson.de>
class provider_o2online_de(provider):
	def getName(self):
		return 'o2online (Germany)'
	def hasAdvancedFeatures(self):
		return True
	def AdvModName(self):
		return 'o2online_de'
	def SetupGUI(self, MainWindow):
		CT = time.localtime(time.time())
		# Set the year for scheduling SMS. From now to the next three years
		YEAR = CT[0]
		for YEARS in range(YEAR,YEAR + 3, 1):
			MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear.addItem(str(YEARS))
			MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopYear.addItem(str(YEARS))
		# Method which is called to get the proper number of days for the schedule start date
		def on_StartDate_changed(self):
			cal = calendar.Calendar()
			sYEAR = int(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear.currentText())
			sMONTH = int(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMonth.currentText())
			MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartDay.clear()
			for DAY in cal.itermonthdays(sYEAR, sMONTH):
				if DAY != 00:
					DAY = '%02d' %(DAY)
					MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartDay.addItem(str(DAY))

		# Method which is called to get the proper number of days for the schedule stop date
		def on_StopDate_changed(self):
			cal = calendar.Calendar()
			sYEAR = int(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopYear.currentText())
			sMONTH = int(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopMonth.currentText())
			MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopDay.clear()
			for DAY in cal.itermonthdays(sYEAR, sMONTH):
				if DAY != 00:
					DAY = '%02d' %(DAY)
					MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopDay.addItem(str(DAY))
		QtCore.QObject.connect(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMonth, QtCore.SIGNAL("activated(QString)"), on_StartDate_changed)
		QtCore.QObject.connect(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopMonth, QtCore.SIGNAL("activated(QString)"), on_StopDate_changed)
		QtCore.QObject.connect(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear, QtCore.SIGNAL("activated(QString)"), on_StartDate_changed)
		QtCore.QObject.connect(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopYear, QtCore.SIGNAL("activated(QString)"), on_StopDate_changed)
		# TODO: Check why the scheduling for o2online.de is not working.
		# TODO: Meanwhile this is disabled.
		MainWindow.AdvSet.ui.groupBox_AdvancedSchedule.setDisabled(True)

	def chars_per_sms(self):
		return 160, 1800

	def num_regexp(self, num):
		# Remove everything except numbers and "+"
		num = re.sub(r'[^(0-9)|\+]', '', num)
		num = re.sub(r'^0{1}', '+49', num)
		num = re.sub(r'^0{2}', '+', num)
		# Check if the number matches either +491732332 or 01732332
		if re.match('^(\+[1-9][0-9]+)', num):
			return True, num, 'Valid Number'
		else:
			return False, num, 'Invalid formated number,'

	# check for CAPTCHA
	def check_captcha(self, response):
		# RegExp to find the sucking CAPTCHA image
		re_cap = re.compile('jcaptchaReg')
		while re_cap.search(str(response)):
			#Instantiate the CAPTCHA dialog
			sc = ShowCAPTCHA()

			## Download the CAPTCHA with urllib2
			#current_url = br.geturl()
			#base_url = current_url[:current_url.rfind("/")]
			#dl_captcha = urllib2.urlopen("%s/jcaptchaReg" %(base_url))
			#qimg = QImage.fromData(dl_captcha.read())
			#pixmap = QPixmap.fromImage(qimg)

			## Download the CAPTCHA with urllib2 and save to jpg
			#current_url = br.geturl()
			#base_url = current_url[:current_url.rfind("/")]
			#dl_captcha = urllib2.urlopen("%s/jcaptchaReg" %(base_url))
			#captcha = open("captcha.jpg", 'wb')
			#captcha.write(dl_captcha.read())
			#captcha.close()
			#pixmap = QPixmap('captcha.jpg')

			## Download CAPTCHA with mechanize
			current_url = self.br.geturl()
			base_url = current_url[:current_url.rfind("/")]
			dl_captcha = br.open("%s/jcaptchaReg" %(base_url)).read(4096*10)
			qimg = QImage.fromData(dl_captcha)
			pixmap = QPixmap.fromImage(qimg)
			self.br.back()

			## Download CAPTCHA with mechanize and save to file
			#current_url = br.geturl()
			#base_url = current_url[:current_url.rfind("/")]
			#dl_captcha = br.open("%s/jcaptchaReg" %(base_url)).read(4096*10)
			#captcha = open("captcha.jpg", 'wb')
			#captcha.write(dl_captcha)
			#captcha.close()
			#pixmap = QPixmap('captcha.jpg')

			#Set captcha.jpg to show up in the CAPTCHA dialog
			sc.ui.label_captcha.setPixmap(pixmap)
			def getcaptcha():
				self.captchatext = unicode(sc.ui.lineEdit_captcha.text())
			QtCore.QObject.connect(sc.ui.buttonBox_Captcha, QtCore.SIGNAL("accepted()"), getcaptcha)
			sc.show()
			sc.exec_()
			br.select_form(name='riddle')
			self.br.form["riddleValue"] = self.captchatext
			try:
				self.br.submit()
			except Exception, e:
				return error(self, MainWindow, e, 'Kommunikationsfehler')

			response = self.br.response().read()
			if self.re_cap.search(str(response)):
				reply = QMessageBox.question(MainWindow, 'CAPTCHA verifikation fehlgeschlagen!', "Nochmal versuchen?", QMessageBox.Yes, QMessageBox.No)
				if reply == QMessageBox.No:
					return error(self, MainWindow, False, 'CAPTCHA verifikation abgebrochen durch User')

	def get_advanced_setting(self, MainWindow):
		    	# Read Scheduling settings if activated
			SCHEDULE = []
			if MainWindow.AdvSet.ui.checkBox_AdvancedScheduleRepeat.isChecked():
				# SCHEDULE Layout: ([RECURRENCY, STOPTrueFalse], [YEARstart, YEARstop], [MONTHstart, MONTHstop], [DAYstart, DAYstop], [HOUREstart, HOUREstop], [MINUTEstart, MINUTEstop])
				SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedRecurrence.currentText()), MainWindow.AdvSet.ui.checkBox_AdvancedScheduleStop.isChecked() ])
				SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear.currentText()), str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopYear.currentText()) ])
				SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMonth.currentText()), str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopMonth.currentText()) ])
				SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartDay.currentText()), str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopDay.currentText()) ])
				SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartHoure.currentText()), str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopHoure.currentText()) ])
				SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMinute.currentText()), str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStopMinute.currentText()) ])
			else:
				SCHEDULE = False

			# Read Sender
			if MainWindow.AdvSet.ui.radioButton_AdvancedMyMobileNumber.isChecked():
				SENDER = "MyNumber"
			elif MainWindow.AdvSet.ui.radioButton_AdvancedAnonym.isChecked():
				SENDER = "Anonym"
			elif MainWindow.AdvSet.ui.radioButton_AdvancedText.isChecked():
				SENDER = MainWindow.AdvSet.ui.lineEdit_AdvancedText.text()

			# Read Special
			FLASH = MainWindow.AdvSet.ui.checkBox_AdvancedFlashSMS.isChecked()

			return SCHEDULE, SENDER, FLASH

	def sendSMS(self, MainWindow, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
		LOGINURL = 'https://o2online.de'
		execute = True
		if execute:
			# Get the values for the advanced settings.
			SCHEDULE, SENDER, FLASH = self.get_advanced_setting(MainWindow)
			MainWindow.Stat.show()
			MainWindow.Stat.ui.progressBar.setMinimum(0)
			MainWindow.Stat.ui.progressBar.setMaximum(9)
			# RegExp to check if SMS was send successfully:
			re_suc = re.compile('erfolgreich', re.IGNORECASE)
			# RegEx to check if en error occured
			re_fail = re.compile('(Fehler beim Login)|(Error logging in)', re.IGNORECASE)
			# RegExp to find the link to the SMS center:
			re_meino2 = re.compile('meino2')
			# RegExp to find remaining FREE SMS:
			re_free = re.compile('Frei-SMS: [0-9]+')

			# Instanziate a Browser
			UpdatePbar(self, MainWindow, app, "1", "Step 1: Initiating the browser")
			try:
				br = mechanize.Browser()
			except Exception, e:
				return error(self, MainWindow, e, "Step 1: Failed to initiate the Browser")

			# Browser options
			# gzip transfer encoding is experimental! --> Disable it
			br.set_handle_gzip(False)
			br.set_handle_referer(True)
			br.set_handle_redirect(True)
			br.set_handle_equiv(True)
			br.set_handle_robots(False)
			#br._factory.encoding = "UTF-8"
			#br._factory._forms_factory.encoding = "UTF-8"
			#br._factory._links_factory._encoding = "UTF-8"

			# Follows refresh 0 but not hangs on refresh > 0
			br.set_handle_refresh(mechanize._http.HTTPRefreshProcessor(), max_time=1)

			# Debugging stuff
			#br.set_debug_http(True)
			#br.set_debug_responses(True)
			#br.set_debug_redirects(True)
			#logger = logging.getLogger("mechanize")
			#logger.addHandler(logging.StreamHandler(sys.stdout))
			#logger.setLevel(logging.DEBUG)

			# User-Agent
			# Mozilla
			#br.addheaders = [('User-agent', 'Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.1.6) Gecko/20100105 Gentoo Firefox/3.5.6')]
			# Opera
			br.addheaders = [('User-agent', 'Opera/9.80 (X11; Linux x86_64; U; en) Presto/2.5.24 Version/10.54 Gentoo')]

			#------------------------------------
			# Open the O2 website
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "2", "Step 2: Open the O2 website")
			try:
				br.open(LOGINURL)
				response = br.response().read()
			except Exception, e:
				return error(self, MainWindow, e, 'Step 2: Failed to open %s' %(LOGINURL))

			#------------------------------------
			# Select the Login form and feed it with the login credentials
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "3", "Step 3: Log in to MyO2")
			try:
				br.select_form(name='loginForm')
			except Exception, e:
				return error(self, MainWindow, e, "Step 3: Faild to select the login Form")
			br.form['loginName'] = LOGIN
			br.form['password'] = PASSWORD
			#br.find_control(name="url").value = ["1"]
			#br.form.find_control(name="url", kind="select").value = ["1]
			#br.form['url'] = ["https://email.o2online.de/ssomanager.osp?APIID=AUTH-WEBSSO&#38;et_cid=22&#38;et_lid=64"]
			try:
				br.submit()
				response = br.response().read()
			except Exception, e:
				return error(self, MainWindow, e, 'Step 3: Failed to load "Mein O2"')
			if re_fail.search(str(response)):
				return error(self, MainWindow, False, 'Step 3: Probably wrong login parameters, check your account setup')

			#------------------------------------
			#Check for CAPTCHA request
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "4", "Step 4: CAPTCHA-Check")
			self.check_captcha(response)

			#------------------------------------
			# Open the EMAIL-Center
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "5", "Step 5: Open EmailCenter")
			try:
				br.find_link(text='E-Mails bearbeiten')
			except mechanize.LinkNotFoundError:
				return error(self, MainWindow, e, 'Step 5: Link "E-Mails bearbeiten" nicht gefunden')
			req = br.click_link(text='E-Mails bearbeiten')
			try:
				br.open(req)
				response = br.response().read()
			except Exception, e:
				return error(self, MainWindow, e, 'Step 5: Failed to open the EmailCenter')

			#------------------------------------
			# Open the SMS-Center
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "6", "Step 6: Open SMSCenter")
			req = 'https://email.o2online.de/smscenter_new.osp?Autocompletion=1&MsgContentID=-1'
			try:
				br.open(req)
				response = br.response().read()
			except Exception, e:
				return error(self, MainWindow, e, 'Step 6: Failed to open the SMSCenter')

			#------------------------------------
			# Select the SMS-Form
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "7", "Step 7: Select the SMS-Form")
			try:
				br.select_form(name='frmSMS')
			except Exception, e:
				return error(self, MainWindow, e, 'Step 7: Failed to select the SMS form')

			# Find how much FREE SMS we have left.
			FREESMS = int(re_free.findall(response)[0].split()[1])

			#------------------------------------
			# Fill the forms
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "8", "Step 8: Fill the forms")
			br.form.set_all_readonly(False)
			# FIll in number
			br.form['SMSTo'] = NUMBER
			# Convert the "unicode" string obtained from the QSTRING to "str"
			# Otherwise mechanize will bail out with:
			# UnicodeEncodeError: 'ascii' codec can't encode characters in position
			br.form['SMSText'] = SMSTEXT.encode(br.encoding())
			# Check for FlashSMS
			if FLASH :
				br.form['FlagFlash'] = '1'
			# Check for Anonymous
			if SENDER == "Anonym" :
				br.form['FlagDefSender'] = '1'
				br.form['FlagAnonymous'] = '1'
			# If neuter Anonymous or a Name is provided we send the SMS with the senders number.
			if SENDER != "MyNumber" and SENDER != "Anonym" :
				br.form['FlagDefSender'] = '1'
				br.form['SMSFrom'] = str(SENDER)
			# Scheduling works half way, the SMS is scheduled, but it is send imediately...
			if SCHEDULE :
				StartDate = '%s,%s,%s,%s,%s,%s' %(str(SCHEDULE[1][0]), str(SCHEDULE[2][0]), str(SCHEDULE[3][0]), str(SCHEDULE[4][0]), str(SCHEDULE[5][0]), '00')
				StopDate = '%s,%s,%s,%s,%s,%s' %(str(SCHEDULE[1][1]), str(SCHEDULE[2][1]), str(SCHEDULE[3][1]), str(SCHEDULE[4][1]), str(SCHEDULE[5][1]), '00')
				# See sourcecode of  the webpage for the mapping:
				Frequency_Dict = {'Daily' : '1', 'Weekly' : '2', 'Monthly': '3', 'Yearly' : '4', 'Once' : '5',  'Hourly' : '6'}
				FQ = str(Frequency_Dict[SCHEDULE[0][0]])
				br.form['RepeatType'] = FQ
				br.form['FolderID'] = '3'
				br.form['RepeatStartDate'] = StartDate
				if SCHEDULE[0][1] :
					br.form['RepeatEndType'] = '1'
					br.form['RepeatEndDate'] = StopDate

			#------------------------------------
			# Finally send the SMS
			#------------------------------------
			UpdatePbar(self, MainWindow, app, "9", "Step 9: Send SMS")
			try:
				#print NUMBER, SMSTEXT, LOGIN, PASSWORD, SCHEDULE, SENDER, FLASH
				br.submit()
				response = br.response().read()
				if re_suc.search(str(response)):
					SMS_LEFT = FREESMS - 1
					return error(self, MainWindow, True, 'Provider responded: Ihre SMS wurde erfolgreich versendet\nVerbleibende SMS: %s' %(SMS_LEFT))
				else:
					return error(self, MainWindow, False, 'Step 9: Provider responded: Ihre SMS wurde nicht versendet\nVerbleibende SMS: %s' %(FREESMS))
			except Exception, e:
					return error(self, MainWindow, e, 'Step 9: Submission faild')

# vodafone.nl 1.0
# Vodafone (NL) Provider written by Shane Kerr <shane@time-travellers.org>
class provider_vodafone_nl(provider):
	def getName(self):
		return 'Vodefone (Nederland)'
	def hasAdvancedFeatures(self):
		return False
	def chars_per_sms(self):
		return 125, 125
	def num_regexp(self, num):
	    	# Get rid of everything except 
		num = re.sub(r'[^(0-9)|\+]', '', num)
		# handle a couple of number formats (only mobile numbers allowed)
		if re.search(r'^\+316\d{8}$', num):	# ITU format, +31 is the Netherlands
			num = number[3:]
			return True, num, 'Valid Number'
		elif re.search(r'^06\d{8}$', num):	# local dialing format
			num = number[1:]
			return True, num, 'Valid Number'
		else:
			return False, num, 'Only Dutch mobile phone numbers allowed'

	def sendSMS(self, MainWindow, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
		# TODO: check whether sending worked
		# TODO: handle "2 per day maximum"
		# TODO: localization support (at least English and Dutch)

                # XXX: GUI manipulation
                MainWindow.Stat.show()
		MainWindow.Stat.ui.progressBar.setMinimum(0)
		MainWindow.Stat.ui.progressBar.setMaximum(8)

		# set up our browser
		UpdatePbar(self, MainWindow, app, "1", "Initiating the browser")
		br = mechanize.Browser()
		cj = cookielib.LWPCookieJar()
		br.set_cookiejar(cj)

		# login
		try:
			UpdatePbar(self, MainWindow, app, "2", "Connecting to login page")
			br.open('https://my.vodafone.nl/prive/my_vodafone')
			UpdatePbar(self, MainWindow, app, "3", "Logging in")
			br.select_form(name='login')
			br.form['username'] = LOGIN
			br.form['password'] = PASSWORD
			br.submit()
		except:
			return False, "Error logging in"


		# verify our login worked and return error if not
	   	UpdatePbar(self, MainWindow, app, "4", "Checking login")
		br.response().read()
		try:
			br.find_link(text='Uitloggen')
		except mechanize.LinkNotFoundError:
			return False, 'Login failed'

		# send the SMS
   	        UpdatePbar(self, MainWindow, app, "5", "Opening SMS page")
		try:
			br.open('https://my.vodafone.nl/Prive/My_Vodafone/gratis_sms_versturen')
		except:
			return False, 'Error opening free SMS web page'
   	        UpdatePbar(self, MainWindow, app, "6", "Checking maximum SMS per day")
		response = br.response().read()
		if re.search(r'Je hebt het maximum aantal gratis SMS\'jes bereikt voor vandaag.', response):
			return False, "Provider responded: Je hebt het maximum aantal gratis SMS'jes bereikt voor vandaag."

   	        UpdatePbar(self, MainWindow, app, "7", "Sending SMS")
		try:
			br.select_form(name='controle')
			br.form['phoneNumber'] = number
			br.form['body'] = SMSTEXT.encode(br.encoding())
			br.submit()
		except:
			print response
			return False, 'Error submitting SMS form'

		# check to see if our send worked
   	        UpdatePbar(self, MainWindow, app, "8", "Confirming SMS sent")
		response = br.response().read()
		if re.search(r'Je sms\'je is verstuurd.', response):
			return True, "Provider responded: Je sms'je is verstuurd."
		elif re.search(r'Je hebt het maximum aantal gratis SMS\'jes voor vandaag verstuurd.', response):
			return False, "Provider responded: Je hebt het maximum aantal gratis SMS'jes voor vandaag verstuurd."
		else:
			return False, 'Message not sent'
        	MainWindow.Stat.close()

# Exetel Australia
# API Docs: http://www.exetel.com.au/Exetel_SMS_API_documentation.pdf
# Exetel Provider written by Janeene Beeforth <n900@dawnmist.net>
class provider_exetel_au(provider):
	def getName(self):
		return 'Exetel (Australia)'
	def hasAdvancedFeatures(self):
		return True
	def AdvModName(self):
		return 'exetel_au'
	def chars_per_sms(self):
		return 160, 608
	def num_regexp(self, num):
	    	# Get rid of everything except 
		num = re.sub(r'[^(0-9)|\+]', '', num)
		# handle a couple of number formats
		if re.search(r'^\+\d{11}$', num):	# ITU format
			return True, num, 'Valid Number'
		elif re.search(r'^\d{11}$', num):	# ITU format with no +
			return True, num, 'Valid Number'
		elif re.search(r'^0\d{9}$', num):	# local dialing format
			return True, num, 'Valid Number'
		else:
			return False, num, 'Unknown number format '.number

	def SetupGUI(self, MainWindow):
		conn = sqlite3.connect('www2sms.db')
		c = conn.cursor()
		ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
		ADVANCED = ""
		try:
			ADVANCED = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
		except sqlite3.OperationalError:
			pass
		if ADVANCED != "None":
			MainWindow.AdvSet.ui.lineEdit_AdvancedText.setText(ADVANCED)
		c.close()
		conn.close()
		CT = time.localtime(time.time())
		# Set the year for scheduling SMS. From now to the next three years
		YEAR = CT[0]
		for YEARS in range(YEAR,YEAR + 3, 1):
			MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear.addItem(str(YEARS))
		# Method which is called to get the proper number of days for the schedule start date
		def on_StartDate_changed(self):
			cal = calendar.Calendar()
			sYEAR = int(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear.currentText())
			sMONTH = int(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMonth.currentText())
			MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartDay.clear()
			for DAY in cal.itermonthdays(sYEAR, sMONTH):
				if DAY != 00:
					DAY = '%02d' %(DAY)
					MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartDay.addItem(str(DAY))

		def on_AdvSetSave_clicked():
			ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
			conn = sqlite3.connect('www2sms.db')
			c = conn.cursor()
			DB_SENDER = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
			SENDER = str(MainWindow.AdvSet.ui.lineEdit_AdvancedText.text())
			if SENDER != "":
			    if DB_SENDER == "None" or SENDER != DB_SENDER :
				c.execute('UPDATE login SET advanced=? WHERE alias=?', (SENDER, ALIAS))
				conn.commit()
			c.close()
			conn.close()
			# Let the user know that we have saved the the account/changes
			QtGui.QMessageBox.information(MainWindow.AdvSet, 'www2sms', "saved")

		QtCore.QObject.connect(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMonth, QtCore.SIGNAL("activated(QString)"), on_StartDate_changed)
		QtCore.QObject.connect(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear, QtCore.SIGNAL("activated(QString)"), on_StartDate_changed)
		QtCore.QObject.connect(MainWindow.AdvSet.ui.pushButton_Save, QtCore.SIGNAL("clicked()"), on_AdvSetSave_clicked)


	def get_advanced_setting(self, MainWindow):
		# Read Sender
		SENDER = MainWindow.AdvSet.ui.lineEdit_AdvancedText.text()
		# Read Scheduling settings if activated
		SCHEDULE = []
		if MainWindow.AdvSet.ui.checkBox_AdvancedSchedule.isChecked():
			# SCHEDULE Layout: ([TrueFalse], [YEARstart], [MONTHstart], [DAYstart], [HOURstart], [MINUTEstart])
			SCHEDULE.append([ MainWindow.AdvSet.ui.checkBox_AdvancedSchedule.isChecked() ])
			SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartYear.currentText())])
			SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMonth.currentText()) ])
			SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartDay.currentText()) ])
			SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartHour.currentText()) ])
			SCHEDULE.append([ str(MainWindow.AdvSet.ui.comboBox_AdvancedScheduleStartMinute.currentText()) ])
		else:
			SCHEDULE = False
		# Don't need Special
		FLASH = False

		return SCHEDULE, SENDER, FLASH

	def sendSMS(self, MainWindow, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
		LOGINURL = 'https://www.exetel.com.au/'
                # XXX: GUI manipulation
		SCHEDULE, SENDER, FLASH = self.get_advanced_setting(MainWindow)
		# Refuse to send without sender number
		if (str(SENDER) == ""):
			return False, 'Not Sent: Exetel requires a Sender number. Please set this in Adv Provider settings in the "Sender" field.'
		
                MainWindow.Stat.show()
		MainWindow.Stat.ui.progressBar.setMinimum(0)
		MainWindow.Stat.ui.progressBar.setMaximum(3)

		# set up our browser
		UpdatePbar(self, MainWindow, app, "1", "Initializing the browser")
		try:
			br = mechanize.Browser()
		except Exception, e:
			return False, "Failed to open browser"

		# strip the '+' if it's still here from the number to send to
		if re.search(r'^\+\d{11}$', NUMBER):	# ITU format - strip the +
			num = re.sub(r'[^(0-9)]', '', NUMBER)
		else:
			num = NUMBER

		# Scheduling
		if SCHEDULE :
			address = 'https://smsgw.exetel.com.au/sendsms/api_sms_schedule.php?username=%s&sender=%s&password=%s&mobilenumber=%s&message=%s&messagetype=Text&requesttype=ADD&scheduledday=%s&scheduledmonth=%s&scheduledyear=%s&scheduledhour=%s&scheduledminute=%s' %(LOGIN, SENDER, PASSWORD, num, urllib.quote_plus(SMSTEXT), SCHEDULE[3][0], SCHEDULE[2][0], SCHEDULE[1][0], SCHEDULE[4][0], SCHEDULE[5][0])
		
		else:
			address = 'https://smsgw.exetel.com.au/sendsms/api_sms.php?username=%s&sender=%s&password=%s&mobilenumber=%s&message=%s&messagetype=Text' %(LOGIN, SENDER, PASSWORD, num, urllib.quote_plus(SMSTEXT))
		try:
			# Uncomment below line for debugging...
			#print("Sending to '" + address + "'")
			UpdatePbar(self, MainWindow, app, "2", 'Sending Message')
			br.open(address)
		except:
			return False, 'Error sending message: Failed to open ' + address
		
		UpdatePbar(self, MainWindow, app, "3", "Checking Reply")
		result = br.response().read().split('|')
		if re.search(r'1', result[0]):
			return True, 'Sent. Provider responded: ' + result[4].replace('<br>', '')
		elif re.search(r'2', result[0]):
			return False, 'Not Sent. Provider responded:  ' + result[4]
		else:
			return False, 'Failed. Provider responded: ' + result[4]

        	MainWindow.Stat.close()


# MutluSMS 1.0 (API v0.2)
# API Docs: http://www.mutlusms.com/yazilimgelistiriciler.html | http://www.mutlusms.com/js/MutluSmsHttpApi.pdf
# MutluSMS (TR) Provider written by Bjoern Olausson <maemo@olausson.de>
class provider_MutluSMS_tu(provider):
	def getName(self):
		return 'MutluSMS (Turkey)'
	def hasAdvancedFeatures(self):
		return True
	def AdvModName(self):
		return 'mutlusms_tu'
	def chars_per_sms(self):
		return 160, 320
	def num_regexp(self, num):
		# Remove everything except numbers and "+"
		num = re.sub(r'[^(0-9)|\+]', '', num)
		#Since we can send SMS anywhere it does not make sense to check for vlidity
		return True, num, 'Valid Number'
		#TODO Check if the number matches either +905321234567 , 905321234567 , 05321234567
		#TODO Handy Vorwahl Türkei (Turkey): 0090542851-8, 0090542871-4, 0090542882-6, 0090542889, 009054, 009053383-7, 009050, 0090551-6, 0090559, 00905, 009053
		#if re.match('^(\+905[0-9]+)|^(905[0-9]+)|^(05[0-9]+)', num):
			#return True, num, 'Valid Number'
		#else:
			#return False, num, 'Invalid formated number. Valid examples: +905321234567 , 905321234567 , 05321234567'

	def SetupGUI(self, MainWindow):
		conn = sqlite3.connect('www2sms.db')
		c = conn.cursor()
		ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
		ADVANCED = ""
		try:
			ADVANCED = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
		except sqlite3.OperationalError:
			pass
		if ADVANCED != "None":
			MainWindow.AdvSet.ui.lineEdit_AdvancedText.setText(ADVANCED)
		c.close()
		conn.close()

		def on_AdvSetSave_clicked():
			ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
			conn = sqlite3.connect('www2sms.db')
			c = conn.cursor()
			DB_SENDER = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
			SENDER = str(MainWindow.AdvSet.ui.lineEdit_AdvancedText.text())
			if SENDER != "":
			    if DB_SENDER == "None" or SENDER != DB_SENDER :
				c.execute('UPDATE login SET advanced=? WHERE alias=?', (SENDER, ALIAS))
				conn.commit()
			c.close()
			conn.close()
			# Let the user know that we have saved the the account/changes
			QtGui.QMessageBox.information(MainWindow.AdvSet, 'www2sms', "saved")

		QtCore.QObject.connect(MainWindow.AdvSet.ui.pushButton_Save, QtCore.SIGNAL("clicked()"), on_AdvSetSave_clicked)

	def get_advanced_setting(self, MainWindow):
		# Read Sender
		SENDER = MainWindow.AdvSet.ui.lineEdit_AdvancedText.text()
		# Flash SMS?
		FLASH = MainWindow.AdvSet.ui.checkBox_AdvancedFlashSMS.isChecked()
		if FLASH:
		    FLASH = 1
		else:
		    FLASH = 0
		return SENDER, FLASH

	def sendSMS(self, MainWindow, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
		SENDER, FLASH = self.get_advanced_setting(MainWindow)
		if SENDER == "":
			return False, 'A sender is required in the advanced Setup'
		MainWindow.Stat.show()
		MainWindow.Stat.ui.progressBar.setMinimum(0)
		MainWindow.Stat.ui.progressBar.setMaximum(2)
		ERROR_MSG = {
			    "11":"Message is too long",
			    "12": "Message has unusable characters: ^ { } [ ] ~ \ |",
			    "13": "Wrong phone number(not sender, the one which gonna get sms)",
			    "14": "Wrong sender name",
			    "15": "Unsupported sender number",
			    "16": "Unsupported sender name",
			    "17": "Flash sms cant have special characters",
			    "18": "Wrong parameter",
			    "19": "You cant send more than 100 person once.",
			    "101": "Wrong authority info",
			    "102": "Wrong username or password",
			    "103": "Not enough credits",
			    "301": "This registry number couldnt found!",
			    "999": "Error about mutlusms (Contact to MutluSMS)"
			    }
		#API URL
		url = "http://www.mutlusms.com/api/gonder.do"
		#Remove invalid chars from message
		MESSAGE = re.sub(r'\^|\{|\}|\[|\]|\~|\\|\|', '', SMSTEXT)
		#Assemble REQUEST
		urlSon = url + "?id=%s&sifre=%s&gonderen=%s&mesaj=%s&telefon=%s&flash=%s" %(LOGIN,PASSWORD,SENDER,urllib.quote_plus(MESSAGE),NUMBER,FLASH)
		UpdatePbar(self, MainWindow, app, "1", "Sending SMS")
		try:
			result = urllib2.urlopen(urlSon).read()
		except URLError, e:
			return False, 'Error connecting to service:%s\n\n %s' %(e.reason, result)
		except HTTPError, e:
			return False, 'Error %s returned from service\n\n %s' %(e.code, result)
		UpdatePbar(self, MainWindow, app, "2", "Checking reply")
		re_suc = re.compile('OK')
		if re_suc.search(result):
		    return True, 'Sent. Message ID: %s' %(result.strip("OK:"))
		else:
		    return False, 'Failed. Provider responded: %s' %(ERROR_MSG[result.strip("HATA:")])
		MainWindow.Stat.close()

# VoipBusterPro 1.1
# API Docs: http://www.voipbusterpro.com/en/sms_instructions.html
# VoipBusterPro Provider written by Bjoern Olausson <maemo@olausson.de>
class provider_VoipBusterPro(provider):
	def getName(self):
		return 'VoipBusterPro'
	def hasAdvancedFeatures(self):
		return True
	def AdvModName(self):
		return 'voipbusterpro'
	def chars_per_sms(self):
		return 160, 160
	def num_regexp(self, num):
		# Remove everything except numbers and "+"
		num = re.sub(r'[^(0-9)|\+]', '', num)
		#Since we can send SMS anywhere it does not make sense to check for vlidity
		return True, num, 'Valid Number'
	def SetupGUI(self, MainWindow):
		conn = sqlite3.connect('www2sms.db')
		c = conn.cursor()
		ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
		ADVANCED = ""
		try:
			ADVANCED = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
		except sqlite3.OperationalError:
			pass
		if ADVANCED != "None":
			MainWindow.AdvSet.ui.lineEdit_AdvancedText.setText(ADVANCED)
		c.close()
		conn.close()

		def on_AdvSetSave_clicked():
			ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
			conn = sqlite3.connect('www2sms.db')
			c = conn.cursor()
			DB_SENDER = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
			SENDER = str(MainWindow.AdvSet.ui.lineEdit_AdvancedText.text())
			if SENDER != "":
			    if DB_SENDER == "None" or SENDER != DB_SENDER :
				c.execute('UPDATE login SET advanced=? WHERE alias=?', (SENDER, ALIAS))
				conn.commit()
			c.close()
			conn.close()
			# Let the user know that we have saved the the account/changes
			QtGui.QMessageBox.information(MainWindow.AdvSet, 'www2sms', "saved")

		QtCore.QObject.connect(MainWindow.AdvSet.ui.pushButton_Save, QtCore.SIGNAL("clicked()"), on_AdvSetSave_clicked)

	def get_advanced_setting(self, MainWindow):
		# Read Sender
		SENDER = MainWindow.AdvSet.ui.lineEdit_AdvancedText.text()
		return SENDER

	def sendSMS(self, MainWindow, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
    		#https://www.voipbusterpro.com/myaccount/sendsms.php?username=xxxxxxxxxx​&password=xxxxxxxxxx&from=xxxxxxxxxx&to=xxxxxxxxxx&text=xxxxxxxxxx
		SENDER = self.get_advanced_setting(MainWindow)
		if SENDER == "":
			return False, 'A sender is required in the advanced Setup'
		MainWindow.Stat.show()
		MainWindow.Stat.ui.progressBar.setMinimum(0)
		MainWindow.Stat.ui.progressBar.setMaximum(2)
		#API URL
		url = "https://www.voipbusterpro.com/myaccount/sendsms.php"
		#Remove invalid chars from message
		MESSAGE = re.sub(r'\^|\{|\}|\[|\]|\~|\\|\|', '', SMSTEXT)
		#Assemble REQUEST
		urlSon = url + "?username=%s&password=%s&from=%s&to=%s&text=%s" %(LOGIN, PASSWORD, SENDER, NUMBER, urllib.quote_plus(MESSAGE))
		UpdatePbar(self, MainWindow, app, "1", "Sending SMS")
		try:
			result = urllib2.urlopen(urlSon).read()
		except URLError, e:
			return False, 'Error connecting to service:%s\n\n %s' %(e.reason, result)
		except HTTPError, e:
			return False, 'Error %s returned from service\n\n %s' %(e.code, result)
		UpdatePbar(self, MainWindow, app, "2", "Checking reply")
		re_suc = re.compile('success', flags=re.IGNORECASE)
		if re_suc.search(result):
		     return True, 'Success. SMS was send' %(result)
		else:
		    return False, 'Failed. Provider responded: %s' %(result)
		MainWindow.Stat.close()

# Telbo 1.1
# API Docs: http://www.telbo.com/en/sms_instructions.html
# Telbo Provider written by Bjoern Olausson <maemo@olausson.de>
class provider_Telbo(provider):
	def getName(self):
		return 'Telbo'
	def hasAdvancedFeatures(self):
		return True
	def AdvModName(self):
		return 'telbo'
	def chars_per_sms(self):
		return 160, 160
	def num_regexp(self, num):
		# Remove everything except numbers and "+"
		num = re.sub(r'[^(0-9)|\+]', '', num)
		#Since we can send SMS anywhere it does not make sense to check for vlidity
		return True, num, 'Valid Number'
	def SetupGUI(self, MainWindow):
		conn = sqlite3.connect('www2sms.db')
		c = conn.cursor()
		ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
		ADVANCED = ""
		try:
			ADVANCED = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
		except sqlite3.OperationalError:
			pass
		if ADVANCED != "None":
			MainWindow.AdvSet.ui.lineEdit_AdvancedText.setText(ADVANCED)
		c.close()
		conn.close()

		def on_AdvSetSave_clicked():
			ALIAS = unicode(MainWindow.AccSet.ui.lineEdit_SetupNewAlias.text())
			conn = sqlite3.connect('www2sms.db')
			c = conn.cursor()
			DB_SENDER = str(c.execute('select advanced FROM login WHERE alias=?', (ALIAS,)).fetchall()[0][0])
			SENDER = str(MainWindow.AdvSet.ui.lineEdit_AdvancedText.text())
			if SENDER != "":
			    if DB_SENDER == "None" or SENDER != DB_SENDER :
				c.execute('UPDATE login SET advanced=? WHERE alias=?', (SENDER, ALIAS))
				conn.commit()
			c.close()
			conn.close()
			# Let the user know that we have saved the the account/changes
			QtGui.QMessageBox.information(MainWindow.AdvSet, 'www2sms', "saved")

		QtCore.QObject.connect(MainWindow.AdvSet.ui.pushButton_Save, QtCore.SIGNAL("clicked()"), on_AdvSetSave_clicked)

	def get_advanced_setting(self, MainWindow):
		# Read Sender
		SENDER = MainWindow.AdvSet.ui.lineEdit_AdvancedText.text()
		return SENDER

	def sendSMS(self, MainWindow, app, NUMBER, SMSTEXT, LOGIN, PASSWORD):
    		#https://www.telbo.com/myaccount/sendsms.php?username=xxxxxxxxxx​&password=xxxxxxxxxx&from=xxxxxxxxxx&to=xxxxxxxxxx&text=xxxxxxxxxx
		SENDER = self.get_advanced_setting(MainWindow)
		if SENDER == "":
			return False, 'A sender is required in the advanced Setup'
		MainWindow.Stat.show()
		MainWindow.Stat.ui.progressBar.setMinimum(0)
		MainWindow.Stat.ui.progressBar.setMaximum(2)
		#API URL
		url = "https://www.telbo.com/myaccount/sendsms.php"
		#Remove invalid chars from message
		MESSAGE = re.sub(r'\^|\{|\}|\[|\]|\~|\\|\|', '', SMSTEXT)
		#Assemble REQUEST
		urlSon = url + "?username=%s&password=%s&from=%s&to=%s&text=%s" %(LOGIN, PASSWORD, SENDER, NUMBER, urllib.quote_plus(MESSAGE))
		UpdatePbar(self, MainWindow, app, "1", "Sending SMS")
		try:
			result = urllib2.urlopen(urlSon).read()
		except URLError, e:
			return False, 'Error connecting to service:%s\n\n %s' %(e.reason, result)
		except HTTPError, e:
			return False, 'Error %s returned from service\n\n %s' %(e.code, result)
		UpdatePbar(self, MainWindow, app, "2", "Checking reply")
		re_suc = re.compile('success', flags=re.IGNORECASE)
		if re_suc.search(result):
		    return True, 'Success. SMS was send' %(result)
		else:
		    return False, 'Failed. Provider responded: %s' %(result)
		MainWindow.Stat.close()
