#!/usr/bin/python
# -*- coding: utf-8 -*-
from PyQt4.QtGui import *
from PyQt4.QtCore import *

#if you use the validator, transform strings to lowercase before comparing them, and the filterproxymodel can be turned case insenstive with one method call
#.setFilterCaseSensitivity(Qt.CaseInsensitive)
class ModelPresenceValidator(QValidator):
	def __init__(self, model, role=Qt.DisplayRole, column=0, parent=None):
		QValidator.__init__(self, parent)
		self.model = model
		self.column = column
		self.role = role
	def validate(self, text, pos):
		lastresort = (QValidator.Invalid, pos)
		for r in xrange(self.model.rowCount()):
			d = self.model.data(self.model.index(r, self.column), self.role).toString()
			print d
			if d == text:
				return (QValidator.Acceptable, pos)
			elif str(d).startswith(str(text)):
				lastresort = (QValidator.Intermediate, pos)
		return lastresort

a = QApplication([])

cb = QComboBox()
cb.addItems(['Albert', 'Alexis', 'Arthur', 'Jane', 'Joe', 'John'])

cb.setEditable(True) # so the user can type
filterproxy = QSortFilterProxyModel()
datmodel = cb.model()
filterproxy.setSourceModel(datmodel) # the filter applies to original data
datmodel.setParent(a) # segfault without this line
cb.setModel(filterproxy) # the combobox will display the filtered content
cb.lineEdit().textEdited.connect(filterproxy.setFilterWildcard) # connect the input to the filter
cb.setValidator(ModelPresenceValidator(datmodel))

cb.show()
a.exec_()