#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#--------------------------------------------------------------------------------
#www2sms.py v1.0.0
#Copyright Bjoern Olausson
#--------------------------------------------------------------------------------
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#To view the license visit
#http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#or write to
#Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#--------------------------------------------------------------------------------
#--------------------------------------------------------------------------------
#

import os, errno, pwd, sys, math, sqlite3, time, calendar, evolution, re
from PyQt4 import QtCore, QtGui
from www2sms_gui_main import *
from www2sms_gui_widget_account import *
from www2sms_gui_dialog_progress import Ui_Form_Progress
import www2sms_providers
#from www2sms_gui_widget_advanced_o2online_de import  Ui_FormAdvanced

USER = pwd.getpwuid(os.getuid())[0]
CONFIG_DIR = "/home/%s/MyDocs/www2sms" %(USER)

#Get the list of providers based on the classes implemented.
list_providers = []
providers = []
for label in dir(www2sms_providers):
    if label.startswith('provider_'):
        provider_class = getattr(www2sms_providers, label)
        provider = provider_class()
	list_providers.append(provider.getName())
	providers.append(provider)

class MainWindow(QtGui.QMainWindow, Ui_MainWindow):
	def __init__(self, win_parent = None):
		#Init the base class
		QtGui.QMainWindow.__init__(self, win_parent)
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)
		# Setup GUI elements
		# Get the phone book
		self.my_phone_book = self.get_contacts()
		# Populate the contact list
		for contact in self.my_phone_book:
			self.ui.comboBox_contact.addItem(contact[0])
		# Populate the available Providers
		for value in list_providers:
			AccSet.ui.comboBox_SetupProvider.addItem(value)
		# Try to update the GUI to the last used Account, else skip this
		try:
			PROVIDER, ALIAS, LOGIN, PASSWORD = c.execute('SELECT provider, alias, login, password FROM login WHERE last=1').fetchall()[0]
			# Populate all Acounts
			self.ACCOUNTS = c.execute('SELECT alias FROM login').fetchall()
			for a in self.ACCOUNTS:
				AccSet.ui.comboBox_SetupAlias.addItem(a[0])
			# Update the GUI
			# Updating the the Provider ComboBox
			provider_index = AccSet.ui.comboBox_SetupProvider.findText(PROVIDER)
			AccSet.ui.comboBox_SetupProvider.setCurrentIndex(provider_index)
			# Updating the the Alias ComboBox
			alias_index = AccSet.ui.comboBox_SetupAlias.findText(ALIAS)
			AccSet.ui.comboBox_SetupAlias.setCurrentIndex(alias_index)
			# Updating the lineEdit Alias
			AccSet.ui.lineEdit_SetupNewAlias.setText(ALIAS)
			# Updating the lineEdit Login
			AccSet.ui.lineEdit_SetupLogin.setText(LOGIN)
			# Updating the lineEdit Pasword
			#PASSWORD = base64.b64decode(PASSWORD)
			AccSet.ui.lineEdit_SetupPassword.setText(PASSWORD)
		except IndexError:
			provider_index = -1
			self.ACCOUNTS = False

		# Connect to some buttons and make them execute a method of the class MainWindow
		QtCore.QObject.connect(self.ui.pushButton_Send, QtCore.SIGNAL("clicked()"), self.on_send_clicked)
		QtCore.QObject.connect(self.ui.comboBox_contact, QtCore.SIGNAL("activated(QString)"), self.comboBox_contact_itemActivated)
		QtCore.QObject.connect(self.ui.comboBox_number, QtCore.SIGNAL("activated(QString)"), self.comboBox_number_itemActivated)
		QtCore.QObject.connect(AccSet.ui.pushButton_SetupSave, QtCore.SIGNAL("clicked()"), self.on_SetupSave_clicked)
		QtCore.QObject.connect(self.ui.plainTextEdit_SMS, QtCore.SIGNAL("textChanged()"), self.UpdateChars)
		QtCore.QObject.connect(AccSet.ui.comboBox_SetupAlias, QtCore.SIGNAL("activated(QString)"), self.on_SetupAlias_activated)
		QtCore.QObject.connect(AccSet.ui.pushButton_SetupDelete, QtCore.SIGNAL("clicked()"), self.on_SetupDelete_clicked)
		self.enableTabs(provider_index)
		self.cpsms(provider_index)
		QtCore.QObject.connect(self.ui.actionAdv_Provider_Settings, QtCore.SIGNAL("triggered(bool)"), self.ShowDialogAdv)
		QtCore.QObject.connect(self.ui.actionAccount_Setup, QtCore.SIGNAL("triggered(bool)"), self.ShowDialogAccSet)
		self.cpsms(provider_index)
    
	def enableTabs(self, provider_index):
		## Enable the SMS SEND Button if we have an account, otherwise not
		if self.ACCOUNTS:
			self.ui.pushButton_Send.setEnabled(True)
		else:
		    	self.ui.pushButton_Send.setEnabled(False)
		## Enable the "advanced" options if supported
		if (provider_index >= 0) and providers[provider_index].hasAdvancedFeatures():
			from www2sms_gui_widget_advanced_o2online_de import  Ui_FormAdvanced
			class FormAdv(QtGui.QDialog, Ui_FormAdvanced):
				def __init__(self, win_parent = None):
					#Init the base class
					QtGui.QDialog.__init__(self, win_parent)
					self.ui = Ui_FormAdvanced()
					self.ui.setupUi(self)
			#The O2 Advanced Form
			self.AdvSet = FormAdv()
			providers[provider_index].SetupGUI(self)
			self.ui.actionAdv_Provider_Settings.setEnabled(True)
		else:
			self.ui.actionAdv_Provider_Settings.setDisabled(True)

	def ShowDialogAdv(self):
		self.AdvSet.show()
	    	#PROVIDER = AccSet.ui.comboBox_SetupProvider.currentText()
	    	# TODO: When there are more providers, a GUI element should be created for every
	    	# TODO: advanced setting. For now only o2online.de has such settings, so AdvSet
	    	# TODO: can be considered the GUI for o2online advanced settings. Thats why we set
	    	# TODO: PROVIDER = 'AdvSet'
	    	#PROVIDER = 'AdvSet'
	    	# Dictionary of all available UIs for advanced settings.
		#p_dict = {'AdvSet' : self.AdvSet.show}
		#p_dict[PROVIDER]()


	def ShowDialogAccSet(self):
		AccSet.show()

	# Function wich generates a nice sorted list for all contacts.
	def get_contacts(self):
		# Regular expression to find all phone numbers in the vCard
		re_tel = re.compile('TEL;TYPE')

		# Not usefull right now...
		name_attributes = [
			"full-name",
			"given-name",
			"family-name",
			"nickname"]

		# Not usefull right now...
		phone_attributes = [
			"assistant-phone",
			"business-phone",
			"business-phone-2",
			"business-fax",
			"callback-phone",
			"car-phone",
			"company-phone",
			"home-phone",
			"home-phone-2",
			"home-fax",
			"isdn-phone",
			"mobile-phone",
			"other-phone",
			"other-fax",
			"pager",
			"primary-phone",
			"radio",
			"telex",
			"tty",]

		# Initiate some variables.
		contact_and_numbers = []
		# Used in another function
		contacts_with_numbers = []

		# Open the default address book
		abook = evolution.ebook.open_addressbook("default")
		contacts = abook.get_all_contacts()
		# Pre sort the contacts.
		contacts.sort(key=lambda obj: obj.get_property(name_attributes[2]))

		# Here we check if the contact has Name, Family Name or alias set.
		# If we have Name and Family Name, we store it in reverse order with ","
		# Else we take what is available
		for econtact in contacts:
			contact = [econtact.get_property(name_attributes[2]), econtact.get_property(name_attributes[1]), econtact.get_property(name_attributes[3])]
			if contact[0] and contact[1]:
				item = "%s, %s" %(contact[0], contact[1])
			elif contact[0] and not contact[1]:
				item = "%s" %(contact[0])
			elif not contact[0] and contact[1]:
				item = "%s" %(contact[1])
			elif not contact[0] and not contact[1] and contact[2]:
				item = "%s" %(contact[2])
			else:
				item = ["No name available"]
			# Everything is stored in UTF-8 so we decode it for the QT-GUI
			contact_and_numbers = [item.decode('utf-8')]

			# Since python-evolution does not yield all contact numbers,
			# we hack around this flaw with VCards.
			vcard = econtact.get_vcard_string()
			for line in vcard.split('\n'):
				if re_tel.search(line):
					number = line.split(':')[1].strip()
					contact_and_numbers.extend([number.decode('utf-8')])
			# Now store the list of contact with all its numbers in in another list
			contacts_with_numbers.append(contact_and_numbers)

		# Here we have to sort the list again, because of the contacts which only had an alias.
		contacts_with_numbers = sorted(contacts_with_numbers)
		# Return the final sorted list contacts_with_numbers:
		# list = [ ['Family Name', 'Name', 'Number1', 'Number2', 'Number(n+1)'], [...], [...] ]
		return contacts_with_numbers

	def comboBox_contact_itemActivated(self):
		self.ui.comboBox_number.clear()
		contact_index = self.ui.comboBox_contact.currentIndex()
		for item in self.my_phone_book[contact_index][1:]:
			try:
				if not item:
					self.ui.comboBox_number.addItem('No number available')
				else:
					self.ui.comboBox_number.addItem(item)
			except:
				pass
		if len(self.my_phone_book[contact_index][1:]) == 0:
			self.ui.lineEdit_Number.setText('No number available')
		else:
			self.ui.lineEdit_Number.setText(self.my_phone_book[contact_index][1])

	def comboBox_number_itemActivated(self):
		item = self.ui.comboBox_number.currentText()
		self.ui.lineEdit_Number.setText(item)

	# Method which is called to get the number of chars per SMS for the current provider.
	# This method must be called whenever the provider in the setup was changed or altered.
	def cpsms(self, provider_index):
	    	self.cps, self.max_c= providers[provider_index].chars_per_sms()
	    	self.cps += 1

	# Method which is called to get the number of characters typed in plainTextEdit_SMS,
	# update lcdNumber_SMSChars and check if chars/sms hav been exceeded
	def UpdateChars(self):
		SMS_CHARS = self.ui.plainTextEdit_SMS.document().characterCount() - 1
		self.ui.label_SMSChars.setText(str(SMS_CHARS))
		CharsLeft = self.max_c - SMS_CHARS
		self.ui.label_SMSCharsLeft.setText(str(CharsLeft))
		if SMS_CHARS > self.max_c and self.ui.pushButton_Send.isEnabled():
		    	QtGui.QMessageBox.information(self, 'www2sms', "Reached maximum allowd characters (%s)" %(self.max_c))
		    	self.ui.pushButton_Send.setEnabled(False)
		if not self.ui.pushButton_Send.isEnabled() and SMS_CHARS <= self.max_c :
			self.ui.pushButton_Send.setEnabled(True)
		# Might be better. Floor to Ceiling division: -(-x//y)
		SMS_COUNT = int(math.ceil(SMS_CHARS / self.cps) + 1)
		self.ui.label_SMSCount.setText(str(SMS_COUNT))

	# Method which updates the GUI to the Account selected in comboBox_SetupAlias
	def on_SetupAlias_activated(self):
		# Get the selected Account
		ALIAS = unicode(AccSet.ui.comboBox_SetupAlias.currentText())
		# Read the settings for the selected Account fom DB
		try:
			PROVIDER, ALIAS, LOGIN, PASSWORD = c.execute('SELECT provider, alias, login, password FROM login WHERE alias=?', (ALIAS,)).fetchall()[0]
		except IndexError:
			pass
		# Update the GUI elements
		provider_index = AccSet.ui.comboBox_SetupProvider.findText(PROVIDER)
		AccSet.ui.comboBox_SetupProvider.setCurrentIndex(provider_index)
		AccSet.ui.lineEdit_SetupNewAlias.setText(ALIAS)
		AccSet.ui.lineEdit_SetupLogin.setText(LOGIN)
		AccSet.ui.lineEdit_SetupPassword.setText(PASSWORD)
		self.enableTabs(provider_index)
		self.cpsms(provider_index)
		# Remove the last account flag to set it on the new/updated profile
		c.execute('UPDATE login SET last=0 WHERE last=1')
		# Set the last flag on the new Account
		c.execute('UPDATE login SET last=1 WHERE alias=?',(ALIAS,))
		conn.commit()

	# Well, this is obvious, isn't it? Okay, it deletes the current selected account.
	def on_SetupDelete_clicked(self):
		# Get the current selected Account
		ALIAS = unicode(AccSet.ui.comboBox_SetupAlias.currentText())
		# Delete it from the DB
		c.execute('DELETE FROM login WHERE alias=?', (ALIAS,))
		conn.commit()
		# Remove the Account from comboBox_SetupAlias
		alias_index = AccSet.ui.comboBox_SetupAlias.findText(ALIAS)
		AccSet.ui.comboBox_SetupAlias.removeItem(alias_index)
		# Check if there is something left in the DB
		ROWS = c.execute('SELECT alias FROM login').rowcount
		# Update the GUI elements
		if ROWS == -1:
			AccSet.ui.lineEdit_SetupNewAlias.clear()
			AccSet.ui.lineEdit_SetupLogin.clear()
			AccSet.ui.lineEdit_SetupPassword.clear()
			self.enableTabs(-1)
		else:
			AccSet.on_SetupAlias_activated()
		QtGui.QMessageBox.information(AccSet, 'www2sms', "Account %s deleted" %(ALIAS))

	# Method which is called, when an account is created/updated
	def on_SetupSave_clicked(self):
		# Gather Account information
		PROVIDER = unicode(AccSet.ui.comboBox_SetupProvider.currentText())
		ALIAS = unicode(AccSet.ui.lineEdit_SetupNewAlias.text())
		LOGIN = unicode(AccSet.ui.lineEdit_SetupLogin.text())
		PASSWORD = unicode(AccSet.ui.lineEdit_SetupPassword.text())
		# Remove the last account flag to set it on the new/updated profile
		c.execute('UPDATE login SET last=0 WHERE last=1')
		# Check if Account exist, if it exists, we update the content in the DB on save, else we add it
		EXIST = c.execute('select alias FROM login WHERE alias=?', (ALIAS,)).fetchall()
		if len(EXIST) != 0:
			c.execute('UPDATE login SET provider=?, login=?, password=?, last=1 WHERE alias=?', (PROVIDER, LOGIN, PASSWORD, ALIAS))
		else:
			c.execute('INSERT INTO login VALUES (NULL, ?, ?, ?, ?, 1)', (PROVIDER, ALIAS, LOGIN, PASSWORD))
			# Add the new Account to comboBox_SetupAlias
		    	AccSet.ui.comboBox_SetupAlias.addItem(ALIAS)
		conn.commit()
		# Let the user know that we have saved the the account/changes
		QtGui.QMessageBox.information(AccSet, 'www2sms', "saved")
		# Update the GUI
		alias_index = AccSet.ui.comboBox_SetupAlias.findText(ALIAS)
		AccSet.ui.comboBox_SetupAlias.setCurrentIndex(alias_index)
		provider_index = AccSet.ui.comboBox_SetupProvider.findText(PROVIDER)
		AccSet.ui.comboBox_SetupProvider.setCurrentIndex(provider_index)
		AccSet.ui.lineEdit_SetupLogin.setText(LOGIN)
		AccSet.ui.lineEdit_SetupPassword.setText(PASSWORD)
		self.enableTabs(provider_index)
		self.cpsms(provider_index)

	# Method which is called when we want to send the sms. It actually calls a method on the providers class
	def on_send_clicked(self):
	    	# Read the provider to use
		PROVIDER = unicode(AccSet.ui.comboBox_SetupProvider.currentText())
		provider_index = AccSet.ui.comboBox_SetupProvider.findText(PROVIDER)
		provider = providers[provider_index]
	    	#Check if a receiver number was provided
		# Read the number to which we send the SMS
		NUMBER = unicode(self.ui.lineEdit_Number.text())
		# Check if an number was entered at all
	    	if not NUMBER:
		    	QtGui.QMessageBox.warning(self, 'www2sms', "Please enter an number")
			return
		# Run the provider specific number checks 
		stat, FIXED_NUMBER, message = providers[provider_index].num_regexp(NUMBER)
		if not stat:
			QtGui.QMessageBox.warning(self, 'www2sms', message)
			return
		if FIXED_NUMBER != NUMBER:
		    	reply = QtGui.QMessageBox.question(self, 'www2sms', "Correcte number?\n%s --> %s" %(NUMBER, FIXED_NUMBER), QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		    	if reply == QtGui.QMessageBox.Yes:
			    	NUMBER = FIXED_NUMBER
				self.ui.lineEdit_Number.setText(NUMBER)
			else:
				return
		# Check if there is some text to send at all
		# Read the text we want to send
		SMSTEXT = unicode(self.ui.plainTextEdit_SMS.toPlainText())
		if not SMSTEXT:
			QtGui.QMessageBox.information(self, 'www2sms', "Please enter some text")
			return
		self.ui.pushButton_Send.setText("Sending...")
		self.ui.pushButton_Send.setEnabled(False)
		# Really ready to send?
		reply = QtGui.QMessageBox.question(self, 'Send SMS?', "Are you sure?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		# If reply is YES, we send the SMS, else we just do nothing
		if reply == QtGui.QMessageBox.Yes:
			self.Stat = FormPro()
			# Read the login
			LOGIN = unicode(AccSet.ui.lineEdit_SetupLogin.text())
			# Read the password
			PASSWORD = unicode(AccSet.ui.lineEdit_SetupPassword.text())
			# send the SMS
			STATUS, MSG = provider.sendSMS(self, app, NUMBER, SMSTEXT, LOGIN, PASSWORD)
			self.Stat.close()
			if STATUS == True:
				self.on_send_success(MSG)
			else:
				self.on_send_failed(MSG)
		self.ui.pushButton_Send.setEnabled(True)
		self.ui.pushButton_Send.setText("Send")

	# Method which is called from providers class when the sms was successfully send
	def on_send_success(self,MSG):
		QtGui.QMessageBox.information(self, 'www2sms', MSG)
		self.ui.lineEdit_Number.clear()
		self.ui.plainTextEdit_SMS.clear()

	# Method which is called from providers class when the sms failed to send
	def on_send_failed(self,MSG):
		QtGui.QMessageBox.warning(self, 'www2sms', MSG)

def DialogStatusMessage(self, statusmessage):
	QtGui.QMessageBox.information(self, 'www2sms', statusmessage)

class FormAccount(QtGui.QDialog, Ui_FormAccount):
	def __init__(self, win_parent = None):
		#Init the base class
		QtGui.QDialog.__init__(self, win_parent)
		self.ui = Ui_FormAccount()
		self.ui.setupUi(self)

class FormPro(QtGui.QDialog, Ui_Form_Progress):
	def __init__(self, win_parent = None):
		#Init the base class
		QtGui.QDialog.__init__(self, win_parent)
		self.ui = Ui_Form_Progress()
		self.ui.setupUi(self)

def mk_db():
    try:
	os.makedirs(CONFIG_DIR, 0755)
    except OSError, e:
	# Pass if the directory exist, else raise a exception
	if e.errno == errno.EEXIST:
	    pass
	else:
	    raise Exception("Failed to create %s. (%s, %s)" %(CONFIG_DIR, errno, strerror))
	# Change to the config dir.
	os.chdir(CONFIG_DIR)
	conn = sqlite3.connect('www2sms.db')
	c = conn.cursor()
	# Create Database
	try:
	    c.execute('''create table login (id INTEGER PRIMARY KEY, provider TEXT, alias TEXT UNIQUE, login TEXT, password TEXT, last INTEGER)''')
	    #c.execute('''create table o2online (id INTEGER PRIMARY KEY, provider TEXT, alias TEXT UNIQUE)''')
	    conn.commit()
	except sqlite3.OperationalError:
	    pass
	c.close()
	conn.close()

# Connect to DB
mk_db()
conn = sqlite3.connect('www2sms.db')
c = conn.cursor()

if __name__ == "__main__":
	# Someone is launching this directly
	# Create the QApplication
	app = QtGui.QApplication(sys.argv)
	#The Status Form
	#Stat = FormPro()
	#The Account Form
	AccSet = FormAccount()
	#The Main window
	ui = MainWindow()
	ui.show()
	# Enter the main loop
	app.exec_()
