#ifndef WPMANAGER_H
#define WPMANAGER_H

#include <QMainWindow>
#include <QDir>
#include <QLabel>
#include <QPushButton>
#include <QListWidgetItem>
#include <QFileSystemWatcher>
#include <QMenu>
#include <QMenuBar>

class deleteDialog;
class wpNew;

namespace Ui {
    class wpManager;
}

class wpManager : public QMainWindow
{
    Q_OBJECT

public:
    explicit wpManager(QWidget *parent = 0);
    ~wpManager();

public slots:
    void viewNames();
    void viewFilenames();

    void updatePrevs();
    void editCurrent();
    void installSet();
    void confirmDelSet();
    void delSet();

    void itemChanged();
    void updateList();
    void reselectAfterEdit();
    void openEditWinTrue();

private:
    Ui::wpManager *ui;

    /************ FUNCTIONS **************/
    void setupWPManMenuBar();
    bool checkSelected();
    void fillImageSetList();
    void changeView();

    /************ VARIABLES **************/
    int i;
    int j;

    QList<QLabel*> manPrev;

    QDir imageSetDir;
    QStringList nameFilters;
    QStringList imageSetPreList; // All .desktop files

    QVector<QVector<QString> > imageSetList; // Filtered to all containing "Type=Background Image"
    // [#][0] = Absolute path+filename
    // [#][1] = X-File1
    // [#][2] = X-File2
    // [#][3] = X-File3
    // [#][4] = X-File4
    // [#][5] = Name
    int listIndex;
    bool addIt;

    QList<QListWidgetItem*> itemList;
    QFile checkFile;

    QFile delFileWithPath;
    deleteDialog* delDialog;

    QFile imageSetPrevFile;
    QString lineInFile;

    wpNew* editWin;
    QFile editFile;

    int curRowBeforeUpdate;
    int curRowBeforeEdit;

    // The view-menu
    QMenuBar* wpManMenuBar;

    enum listView {
        names,
        filenames
    } fileView;

    QFileSystemWatcher watchDir;
    bool openEditWin;
};

#endif // WPMANAGER_H
