#ifndef WPNEW_H
#define WPNEW_H

#include <QMainWindow>
#include <QLabel>
#include <QDir>
#include <QVBoxLayout>
#include <QMenuBar>
#include <QMenu>
#include <QAction>
#include <QPushButton>

#include "copytodialog.h"
#include "ui_copytodialog.h"
#include "overwritedialog.h"
#include "ui_overwritedialog.h"
#include "savedialog.h"
#include "ui_savedialog.h"

namespace Ui {
    class wpNew;
}

class wpNew : public QMainWindow
{
    Q_OBJECT

    friend class wpManager;

public:
    explicit wpNew(QWidget* parent = 0);
    ~wpNew();

protected:
    Ui::wpNew* ui;

    /************ FUNCTIONS **************/
    void openImage(int);

    // Is called after opening image
    void setupCopyToBtn(int);

    // Is called by slot clickedCopyToBtn, creates copyImage (dialog) with curCopyToBtn disabled
    void createCopyImage(int);

    // Updates imgBtnPrev# according to imgPath(int)
    void updateImgBtnPrev(int);

    void setupFIMenuBar();

    void createOwDialog();
    void checkDesktopFileSaved();

    /************ VARIABLES **************/
    // One int to rule them all! (for-loops)
    int i;
    // int j is used in copyToOthers(), called functions from copyToOthers() use int i
    int j;

    QString* fileWithPath;
    QDir lastUsedDir;

    // Variables below are for saving .desktop file
    QFile saveFile;
    QString saveFileName;

    QList<QString*> imgPath;
    QList<QPushButton*> imgBtnPrev;
    QList<QLabel*> imgPrevName;

    // Buttons under imgBtnPrev# (main screen)
    QList<QPushButton*> copyToBtn;

    // Check if copyToBtn# exists
    QList<bool*> copyToBtnExists;

    // Put vertical layouts (from ui) in QList for convenience of index number
    QList<QVBoxLayout*> vertLayout;

    copyToDialog* copyImage;
    QList<QPushButton*> copyImageBtn;
    bool copyImageExists;

    // Is defined in createCopyImage(), tells which copyToBtn is pressed
    // so copyToOthers() knows the source path from which it needs to copy
    int curCopyToBtn;

    // Takes path from source defined by curCopyToBtn
    QString* srcPath;

    // The menu and its actions
    QMenu* fiMenu;
    QAction* fiMenuActionReset;

    saveDialog* svDialog;
    bool svDialogIsMade;

    // The overwrite dialog with its contents
    bool owDialogExists;
    overwriteDialog* owDialog;

public slots:
    // Slots for imgBtnPrev#, these slots open openImage()
    void clickedImgBtnPrev0();
    void clickedImgBtnPrev1();
    void clickedImgBtnPrev2();
    void clickedImgBtnPrev3();

    // This also updates nameEditLower, which is the filename
    void updateSaveBtn();
    void createSvDialog();

    // Called when clicking on copyToBtn# (on main screen)
    void clickedCopyToBtn0();
    void clickedCopyToBtn1();
    void clickedCopyToBtn2();
    void clickedCopyToBtn3();

    void setSaveFileName();
    void saveDesktopFile();

    void confirmOverwrite();

    void copyToOthers();

    // Empty everything
    void resetScreen();
};

#endif // WPNEW_H
