#ifndef WPMANAGER_H
#define WPMANAGER_H

#include "wpnew.h"
#include "ui_wpnew.h"
#include "deletedialog.h"
#include "ui_deletedialog.h"

#include <QMainWindow>
#include <QDir>
#include <QLabel>
#include <QPushButton>
#include <QListWidgetItem>

namespace Ui {
    class wpManager;
}

class wpManager : public QMainWindow
{
    Q_OBJECT

public:
    explicit wpManager(QWidget *parent = 0);
    ~wpManager();

public slots:
    void viewNames();
    void viewFilenames();
    void manPrevBtnClicked();
    void manEditBtnClicked();
    void manDelBtnClicked();
    void delSet();
    void itemChanged();
    void updateListAfterEdit();

private:
    Ui::wpManager *ui;

    /************ FUNCTIONS **************/
    void setupWPManMenuBar();
    void updateList();
    void changeCurItem(QListWidgetItem*,QListWidgetItem*);

    bool fileExistsCheck();
    void updatePrevs();
    void editCurrent();
    void confirmDelSet();

    void fillImageSetList();

    /************ VARIABLES **************/
    int i;
    int j;

    bool fileExists;

    QList<QLabel*> manPrev;

    QDir imageSetDir;
    QStringList nameFilters;
    QStringList imageSetPreList; // All .desktop files

    QVector<QVector<QString> > imageSetList; // Filtered to all containing "Type=Background Image"
    // [#][0] = Absolute path+filename
    // [#][1] = X-File1
    // [#][2] = X-File2
    // [#][3] = X-File3
    // [#][4] = X-File4
    // [#][5] = Name
    int listIndex;
    bool addIt;

    QList<QListWidgetItem*> itemList;
        QFile checkFile;

    QFile delFileWithPath;
    deleteDialog* delDialog;
    bool delDialogIsMade;

    QFile imageSetPrevFile;
    QString lineInFile;

    wpNew* editWin;
    QFile editFile;

    int curRowBeforeEdit;

    // The view-menu
    QMenu* wpManMenu;
    QAction* wpManViewNames;
    QAction* wpManViewFilenames;

    enum listView {
        names,
        filenames
    } fileView;
};

#endif // WPMANAGER_H
