#ifndef WPMANAGER_H
#define WPMANAGER_H

#include "wpnew.h"
#include "ui_wpnew.h"
#include "deletedialog.h"
#include "ui_deletedialog.h"

#include <QMainWindow>
#include <QDir>
#include <QLabel>
#include <QPushButton>
#include <QListWidgetItem>
#include <QFileSystemWatcher>

namespace Ui {
    class wpManager;
}

class wpManager : public QMainWindow
{
    Q_OBJECT

public:
    explicit wpManager(QWidget *parent = 0);
    ~wpManager();

public slots:
    void viewNames();
    void viewFilenames();
    void updatePrevs();
    void editCurrent();
    void confirmDelSet();
    void delSet();
    void itemChanged();
    void updateList();
    void reselectAfterEdit();
    void openEditWinTrue();

private:
    Ui::wpManager *ui;

    /************ FUNCTIONS **************/
    void setupWPManMenuBar();
    bool checkSelected();
    void fillImageSetList();
    void changeView();

    /************ VARIABLES **************/
    int i;
    int j;

    QList<QLabel*> manPrev;

    QDir imageSetDir;
    QStringList nameFilters;
    QStringList imageSetPreList; // All .desktop files

    QVector<QVector<QString> > imageSetList; // Filtered to all containing "Type=Background Image"
    // [#][0] = Absolute path+filename
    // [#][1] = X-File1
    // [#][2] = X-File2
    // [#][3] = X-File3
    // [#][4] = X-File4
    // [#][5] = Name
    int listIndex;
    bool addIt;

    QList<QListWidgetItem*> itemList;
    QFile checkFile;

    QFile delFileWithPath;
    deleteDialog* delDialog;
    bool delDialogIsMade;

    QFile imageSetPrevFile;
    QString lineInFile;

    wpNew* editWin;
    QFile editFile;

    int curRowBeforeUpdate;
    int curRowBeforeEdit;

    // The view-menu
    QMenu* wpManMenu;
    QAction* wpManViewNames;
    QAction* wpManViewFilenames;

    enum listView {
        names,
        filenames
    } fileView;

    QFileSystemWatcher watchDir;
    bool openEditWin;
};

#endif // WPMANAGER_H
