#include "fourimages.h"
#include "ui_fourimages.h"
#include "wpmanager.h"
#include "ui_wpmanager.h"
#include "wallpaeper.h"
#include "ui_wallpaeper.h"

wallPaeper::wallPaeper(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::wallPaeper)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);

    aboutDialogExists = false;
    setupWPMenuBar();

    connect(ui->fourBtn, SIGNAL(clicked()),
            this, SLOT(fourBtnClicked()));
    connect(ui->manBtn, SIGNAL(clicked()),
            this, SLOT(manBtnClicked()));
}

wallPaeper::~wallPaeper()
{
    delete ui;
}

void wallPaeper::fourBtnClicked() {
    fourWin = new fourImages(this);
    fourWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    fourWin->setAttribute(Qt::WA_DeleteOnClose);
    fourWin->show();
}

void wallPaeper::manBtnClicked() {
    manWin = new wpManager(this);
    manWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    manWin->setAttribute(Qt::WA_DeleteOnClose);
    manWin->show();
}

void wallPaeper::setupWPMenuBar() {
    wpMenuActionAbout = new QAction(tr("About..."), this);

    wpMenu = menuBar()->addMenu("");
    wpMenu->addAction(wpMenuActionAbout);

    connect(wpMenuActionAbout, SIGNAL(triggered()),
            this, SLOT(createAboutDialog()));
}

void wallPaeper::createAboutDialog() {
    // Only create a new dialog if it hasn't been made yet
    if(aboutDialogExists == false) {
        aboutDialog = new QDialog(this);
        aboutDialog->setWindowTitle("Wallpaeper 0.1-1" + tr(" for ") + "Nokia N900");

        aboutIcon = new QLabel;
        aboutIcon->setPixmap(QPixmap(":/icons/64x64/wallpaeper.png"));
        aboutIcon->adjustSize();

        aboutText1 = new QLabel;
        aboutText1->setWordWrap(true);
        aboutText1->setText(tr("Create, preview, edit and delete .desktop files (image sets), ")
                           + tr("which can be set as the desktop wallpaper.\n\n"));
        aboutText1->adjustSize();

        aboutText2 = new QLabel;
        aboutText2->setWordWrap(true);
        aboutText2->setText("Copyright  2010 Sybren Dijkstra\n('Berserk'" + tr(" on ") + "Maemo.org)");
        aboutText2->adjustSize();

        aboutOK = new QPushButton;
        aboutOK->setMinimumSize(190, 60);
        aboutOK->setMaximumSize(190, 60);
        aboutOK->setText("OK");
        connect(aboutOK, SIGNAL(clicked()),
                wallPaeper::aboutDialog, SLOT(close()));

        aboutLayoutV1 = new QVBoxLayout;
        aboutLayoutV1->addWidget(aboutIcon);
        aboutLayoutV1->setAlignment(Qt::AlignTop);

        aboutLayoutV2 = new QVBoxLayout;
        aboutLayoutV2->addWidget(aboutText1);
        aboutLayoutV2->addWidget(aboutText2);
        aboutLayoutV2->setAlignment(Qt::AlignTop);

        aboutLayoutV3 = new QVBoxLayout;
        aboutLayoutV3->addWidget(aboutOK);
        aboutLayoutV3->setAlignment(Qt::AlignBottom);

        aboutLayoutH = new QHBoxLayout;
        aboutLayoutH->addLayout(aboutLayoutV1);
        aboutLayoutH->addLayout(aboutLayoutV2);
        aboutLayoutH->addLayout(aboutLayoutV3);

        aboutDialog->setLayout(aboutLayoutH);
        aboutDialog->adjustSize();
    }
    aboutDialog->show();
}
