#ifndef FOURIMAGES_H
#define FOURIMAGES_H

#include <QMainWindow>
#include <QLabel>
#include <QDir>
#include <QTextStream>
#include <QBoxLayout>
#include <QMenuBar>
#include <QMenu>
#include <QAction>
#include <QPushButton>

namespace Ui {
    class fourImages;
}

class fourImages : public QMainWindow
{
    Q_OBJECT

    friend class wpManager;

public:
    explicit fourImages(QWidget* parent = 0);
    ~fourImages();

protected:
    Ui::fourImages* ui;

    /************ FUNCTIONS **************/
    void openImage(int);

    // Is called after opening image
    void setupCopyToBtn(int);

    // Is called by slot clickedCopyToBtn, creates copyToDialog with curCopyToBtn disabled
    void createCopyToDialog(int);
    // Creates buttons for copyToDialog
    void createCopyToDialogBtns();

    // Updates imgBtnPrev# according to imgPath(int)
    void updateImg(int);

    void setupFIMenuBar();

    void saveDesktopFile();
    void createOverwriteDialog();
    void checkDesktopFileSaved();

    /************ VARIABLES **************/
    // One int to rule them all! (for-loops)
    int i;
    // int j is used in copyToOthers(), called functions from copyToOthers() use int i
    int j;

    QString* fileWithPath;
    QDir lastUsedDir;
    QString nameEditLower;

    // Variables below are for saving .desktop file
    QFile saveFile;
    QTextStream fileContent;

    QList<QString*> imgPath;
    QList<QPushButton*> imgBtnPrev;

    // Buttons under imgBtnPrev# (main screen)
    QList<QPushButton*> copyToBtn;

    // Check if copyToBtn# exists
    QList<bool*> copyToBtnExists;

    // Put vertical layouts (from ui) in QList for convenience of index number
    QList<QVBoxLayout*> vertLayout;

    // copyToDialog + buttons and layout (after clicking copyToBtn#)
    // also a check if it exists, don't make multiple
    bool copyToDialogExists;
    QDialog* copyToDialog;
        QList<QPushButton*> copyToDialogBtn;
        QPushButton* copyToDialogOK;
        QHBoxLayout* copyToDialogH1;
        QHBoxLayout* copyToDialogH2;
        QVBoxLayout* copyToDialogV;

    // Is defined in createCopyToDialog(), tells which copyToDialogBtn is pressed
    // so copyToOthers() knows the source path from which it needs to copy
    int curCopyToBtn;

    // Takes path from source defined by curCopyToBtn
    QString* srcPath;

    // The menu and its actions
    QMenu* fiMenu;
    QAction* fiMenuActionReset;

    // The overwrite dialog with its contents
    bool overwriteDialogExists;
    QDialog* overwriteDialog;
        QHBoxLayout* owHLayout;
        QVBoxLayout* owVLayout1;
        QVBoxLayout* owVLayout2;
        QLabel* owQuestion;
        QPushButton* owYes;
        QPushButton* owNo;

public slots:
    // Slots for imgBtnPrev#, these slots open openImage()
    void clickedImgBtnPrev0();
    void clickedImgBtnPrev1();
    void clickedImgBtnPrev2();
    void clickedImgBtnPrev3();

    // This also updates nameEditLower, which is the filename
    void updateSaveBtn();
    void setSaveFile();

    // Called when clicking on copyToBtn# (on main screen)
    void clickedCopyToBtn0();
    void clickedCopyToBtn1();
    void clickedCopyToBtn2();
    void clickedCopyToBtn3();

    void confirmOverwrite();

    void copyToOthers();

    // Empty everything
    void resetScreen();
};

#endif // FOURIMAGES_H
