#include "fourimages.h"
#include "ui_fourimages.h"
#include "wallpaeper.h"
#include "ui_wallpaeper.h"

#include <QFileDialog>
#include <QMaemo5InformationBox>

fourImages::fourImages(QWidget* parent) :
    QMainWindow(parent),
    ui(new Ui::fourImages)
{
    ui->setupUi(this);

    // Setup a few QLists with 4 items each
    for(i=0; i<4; i++) {
        // Objects
        copyToBtn.append(new QPushButton);
        copyToBtnExists.append(new bool);
        imgPath.append(new QString);

        // UI elements
        vertLayout.append(new QVBoxLayout);
        imgBtnPrev.append(new QPushButton);
    }

    setupFIMenuBar();

    vertLayout[0] = ui->verticalLayout_1;
    vertLayout[1] = ui->verticalLayout_2;
    vertLayout[2] = ui->verticalLayout_3;
    vertLayout[3] = ui->verticalLayout_4;
    for(i=0; i<4; i++)
        vertLayout[i]->setAlignment(Qt::AlignTop);

    imgBtnPrev[0] = ui->imgBtnPrev1;
    imgBtnPrev[1] = ui->imgBtnPrev2;
    imgBtnPrev[2] = ui->imgBtnPrev3;
    imgBtnPrev[3] = ui->imgBtnPrev4;

    ui->visibChkbox->setChecked(false);

    for(i=0; i<4; i++)
        *copyToBtnExists[i] = false;

    fileWithPath = new QString;

    copyToDialogExists = false;
    overwriteDialogExists = false;
    curCopyToBtn = 8;
    // This default dir changes after selecting an image
    lastUsedDir = "/home/user/MyDocs/.images/";

    QRegExp nameRegExp("^[a-zA-Z0-9_-\\s]*$");
    // ^                From the beginning of the string
    // [a-zA-Z0-9_-\s]    Only alphanumeric, _ and - and whitespace
    // *                At least 0
    // $                Until the end of the string
    ui->nameEdit->setValidator(new QRegExpValidator(nameRegExp, ui->nameEdit));

    for(i=0; i<4; i++) {
        imgBtnPrev[i]->setText(tr("Image ") + QString::number(i+1));
        imgBtnPrev[i]->setStyleSheet("color: black; border-image: url(:/images/select"
                                     + QString::number(i+1)
                                     + ".png);");
    }

    connect(imgBtnPrev[0], SIGNAL(clicked()),
            this, SLOT(clickedImgBtnPrev0()));
    connect(imgBtnPrev[1], SIGNAL(clicked()),
            this, SLOT(clickedImgBtnPrev1()));
    connect(imgBtnPrev[2], SIGNAL(clicked()),
            this, SLOT(clickedImgBtnPrev2()));
    connect(imgBtnPrev[3], SIGNAL(clicked()),
            this, SLOT(clickedImgBtnPrev3()));

    connect(copyToBtn[0], SIGNAL(clicked()),
            this, SLOT(clickedCopyToBtn0()));
    connect(copyToBtn[1], SIGNAL(clicked()),
            this, SLOT(clickedCopyToBtn1()));
    connect(copyToBtn[2], SIGNAL(clicked()),
            this, SLOT(clickedCopyToBtn2()));
    connect(copyToBtn[3], SIGNAL(clicked()),
            this, SLOT(clickedCopyToBtn3()));

    connect(ui->nameEdit, SIGNAL(textChanged(QString)),
            this, SLOT(updateSaveBtn()));

    connect(ui->saveBtn, SIGNAL(clicked()),
            this, SLOT(setSaveFile()));

    connect(ui->visibChkbox, SIGNAL(clicked()),
            this, SLOT(updateSaveBtn()));
}

fourImages::~fourImages() {
    delete ui;
}





//********* START fourImages public functions *******************
void fourImages::setupFIMenuBar() {
    fiMenuActionReset = new QAction(tr("Reset screen"), this);

    fiMenu = menuBar()->addMenu("");
    fiMenu->addAction(fiMenuActionReset);

    connect(fiMenuActionReset, SIGNAL(triggered()),
            this, SLOT(resetScreen()));
}

void fourImages::openImage(int imgIndex) {
    *fileWithPath = QFileDialog::getOpenFileName(this,
                                                 "Open image",
                                                 lastUsedDir.path()); // No filedialog title

    if(!fileWithPath->isEmpty()) { // If the filedialog is NOT cancelled (path NOT empty)
        // Save last used directory for next button press
        lastUsedDir.setPath(QFileInfo(*fileWithPath).absolutePath());

        *imgPath[imgIndex] = *fileWithPath;
        updateImg(imgIndex);
        setupCopyToBtn(imgIndex);
        updateSaveBtn();
    }
}

void fourImages::setupCopyToBtn(int imgBtnPrevNum) {
    // Setup the current copyToBtn
    // If hidden after resetScreen(), show it again
    if(*copyToBtnExists[imgBtnPrevNum] == true && copyToBtn[imgBtnPrevNum]->isVisible() == false)
        copyToBtn[imgBtnPrevNum]->setVisible(true);
    else if(*copyToBtnExists[imgBtnPrevNum] == false) {
        copyToBtn[imgBtnPrevNum]->setParent(this);
        copyToBtn[imgBtnPrevNum]->setMaximumSize(190, 50);
        copyToBtn[imgBtnPrevNum]->setText(tr("Copy to..."));
        copyToBtn[imgBtnPrevNum]->setVisible(true);
        vertLayout[imgBtnPrevNum]->addWidget(copyToBtn[imgBtnPrevNum], 0, Qt::AlignHCenter);
    }
    *copyToBtnExists[imgBtnPrevNum] = true;
}

void fourImages::createCopyToDialog(int copyToBtnNum) {
    // Don't create a new copyToDialog if it exists already
    // Just enable buttons again
    if(copyToDialogExists == true) {
        for(i=0; i<4; i++) {
            copyToDialogBtn[i]->setEnabled(true);
            copyToDialogBtn[i]->setChecked(false);
        }
    }
    else if(copyToDialogExists == false) {
        copyToDialog = new QDialog(this);
        copyToDialog->setWindowTitle("Copy to...");

        createCopyToDialogBtns();

        copyToDialogOK = new QPushButton;
        copyToDialogOK->setText("OK");
        copyToDialogOK->setMinimumSize(190, 60);
        copyToDialogOK->setMaximumSize(190, 60);

        // OK button closes dialog and copies images
        connect(copyToDialogOK, SIGNAL(clicked()),
                fourImages::copyToDialog, SLOT(close()));
        connect(copyToDialogOK, SIGNAL(clicked()),
                this, SLOT(copyToOthers()));

        // Layout all the buttons
        copyToDialogH1 = new QHBoxLayout;
        for(i=0; i<4; i++)
            copyToDialogH1->addWidget(copyToDialogBtn[i]);
        copyToDialogH1->setAlignment(Qt::AlignHCenter);

        copyToDialogH2 = new QHBoxLayout;
        copyToDialogH2->addWidget(copyToDialogOK);
        copyToDialogH2->setAlignment(Qt::AlignHCenter);

        copyToDialogV = new QVBoxLayout;
        copyToDialogV->addLayout(copyToDialogH1);
        copyToDialogV->addLayout(copyToDialogH2);

        copyToDialog->setLayout(copyToDialogV);
        copyToDialog->adjustSize();
        copyToDialogExists = true;
    }

    // Disable the button that is being copied from
    for(i=0; i<4; i++) {
        if(copyToBtnNum == i) { // If user wants to copy image #, disable button #
            curCopyToBtn = i;
            copyToDialogBtn[i]->setEnabled(false);
            copyToDialogBtn[i]->setChecked(false);
        }
        else if(copyToBtnNum < 0 || copyToBtnNum > 3) { // If current button value is not valid
            // Checks 4 times, so disables all 4 buttons
            copyToDialogBtn[i]->setEnabled(false);
            copyToDialogBtn[i]->setChecked(false);
        }
    }

    copyToDialog->show();
}

void fourImages::createCopyToDialogBtns() {
    // Create and setup 4 copyToDialogBtn's
    for(i=0; i<4; i++) {
        copyToDialogBtn.append(new QPushButton);
        copyToDialogBtn[i]->setText(tr("Image ") + QString::number(i+1));
        copyToDialogBtn[i]->setMinimumSize(190, 60);
        copyToDialogBtn[i]->setMaximumSize(190, 60);
        copyToDialogBtn[i]->setCheckable(true);
        copyToDialogBtn[i]->setChecked(false);
        copyToDialogBtn[i]->setEnabled(true);
    }
}

void fourImages::updateImg(int pathNum) {
    // Update imgBtnPrev[#] according to *imgPath[pathNum]
    imgBtnPrev[pathNum]->setStyleSheet("border-image: url(" + *imgPath[pathNum] + ")");
    imgBtnPrev[pathNum]->setText("");
}

void fourImages::saveDesktopFile() {
    saveFile.open(QFile::WriteOnly | QFile::Truncate);
        QTextStream fileContent(&saveFile);
        fileContent << "[Desktop Entry]\n"
                << "Type=Background Image\nName=" << ui->nameEdit->text() << "\n"
                << "Hidden=True\n\n"
                << "X-File1=" << *imgPath[0] << "\n"
                << "X-File2=" << *imgPath[1] << "\n"
                << "X-File3=" << *imgPath[2] << "\n"
                << "X-File4=" << *imgPath[3] << "\n\n"
                << "X-Order=01";
    saveFile.close();
}

void fourImages::createOverwriteDialog() {
    // Don't create the dialog if it exists already
    // Just update owQuestion
    if(overwriteDialogExists == true) {
        owQuestion->setText(nameEditLower + tr(".desktop already exists, overwrite?"));
        owQuestion->adjustSize();
    }
    else if(overwriteDialogExists == false) {
        overwriteDialog = new QDialog(this);
        overwriteDialog->setWindowTitle(tr("Overwrite existing file?"));

            owQuestion = new QLabel;
            owQuestion->setText(nameEditLower + tr(".desktop already exists, overwrite?"));
            owQuestion->adjustSize();

            owYes = new QPushButton;
            owYes->setText(tr("Yes"));
            owYes->setMinimumSize(190, 70);
            owYes->setMaximumSize(190, 70);
            connect(owYes, SIGNAL(clicked()),
                    this, SLOT(confirmOverwrite()));

            owNo = new QPushButton;
            owNo->setText(tr("No"));
            owNo->setMinimumSize(190, 70);
            owNo->setMaximumSize(190, 70);
            connect(owNo, SIGNAL(clicked()),
                    fourImages::overwriteDialog, SLOT(close()));

            owVLayout1 = new QVBoxLayout;
            owVLayout1->addWidget(owQuestion);
            owVLayout1->setAlignment(Qt::AlignHCenter);

            owVLayout2 = new QVBoxLayout;
            owVLayout2->addWidget(owYes);
            owVLayout2->addWidget(owNo);

            owHLayout = new QHBoxLayout;
            owHLayout->addLayout(owVLayout1);
            owHLayout->addLayout(owVLayout2);

        overwriteDialog->setLayout(owHLayout);
        overwriteDialog->adjustSize();
    }

    overwriteDialog->show();
}

void fourImages::checkDesktopFileSaved() {
    if(saveFile.exists() == true)
        QMaemo5InformationBox::information(this,
                                           "<br><b>"
                                           + tr("Image set saved!")
                                           + "</b><br><br>"
                                           + saveFile.fileName()
                                           + "<br>",
                                           QMaemo5InformationBox::NoTimeout);
    if(saveFile.exists() == false)
        QMaemo5InformationBox::information(this,
                                           "<br><b>"
                                           + tr("Image set NOT saved...")
                                           + "</b><br><br>"
                                           + tr("Please try again")
                                           + "<br>",
                                           QMaemo5InformationBox::NoTimeout);
}
//********* END fourImages public functions *******************





//********* START fourImages public slots *******************
void fourImages::clickedImgBtnPrev0() { openImage(0); }
void fourImages::clickedImgBtnPrev1() { openImage(1); }
void fourImages::clickedImgBtnPrev2() { openImage(2); }
void fourImages::clickedImgBtnPrev3() { openImage(3); }

void fourImages::updateSaveBtn() {
    if(ui->nameEdit->text().isEmpty()
        || *imgPath[0] == ""
        || *imgPath[1] == ""
        || *imgPath[2] == ""
        || *imgPath[3] == "") // If one or more objects are empty
    {
        // saveBtn disabled, set default button text
        ui->saveBtn->setEnabled(false);
        ui->saveBtn->setText(tr("Please set name and images first"));
    } else { // If everything is filled in
        // Enable and update saveBtn, update nameEditLower (nameEdit lowercase)
        ui->saveBtn->setEnabled(true);
        nameEditLower = ui->nameEdit->text().toLower();
        // Remove whitespace for savefile
        nameEditLower.replace(" ", "");
        // Check if "Invisible file" is checked, change filename accordingly
        if(ui->visibChkbox->isChecked())
            nameEditLower = "." + nameEditLower;
        ui->saveBtn->setText(tr("Save ") + nameEditLower + ".desktop");
    }
}

void fourImages::setSaveFile() {
    // Always save to /home/user/MyDocs/.images/
    saveFile.setFileName("/home/user/MyDocs/.images/" + nameEditLower + ".desktop");

    if(saveFile.exists()) {
        // File already exists, overwrite?
        createOverwriteDialog();
    } else {
        // File doesn't exist, save the .desktop file
        saveDesktopFile();
        // After saving, check if the file is saved
        checkDesktopFileSaved();
    }
}

void fourImages::clickedCopyToBtn0() { createCopyToDialog(0); }
void fourImages::clickedCopyToBtn1() { createCopyToDialog(1); }
void fourImages::clickedCopyToBtn2() { createCopyToDialog(2); }
void fourImages::clickedCopyToBtn3() { createCopyToDialog(3); }

void fourImages::confirmOverwrite() {
    overwriteDialog->close();
    // Save the .desktop file
    saveDesktopFile();
    // After saving, check if the file is saved
    checkDesktopFileSaved();
}

void fourImages::copyToOthers() {
    // Current source image number is defined in curCopyToBtn
    srcPath = new QString;

    // Store source
    for(i=0; i<4; i++) {
        if(curCopyToBtn == i)
            *srcPath = *imgPath[i];
    }

    // Copy from source path to imgPath[#], based on checked buttons
    // then updates imgBtnPrev[#] and copyToBtn[#]
    for(j=0; j<4; j++) {
        if(copyToDialogBtn[j]->isChecked() == true) {
            *imgPath[j] = *srcPath;
            updateImg(j);
            setupCopyToBtn(j);
        }
    }
    // updateSaveBtn afterwards
    updateSaveBtn();
}

void fourImages::resetScreen() {
    // nameEdit
    ui->nameEdit->setText("");
    ui->visibChkbox->setChecked(false);
    // imgPath, imgBtnPrev, copyToBtn
    for(i=0; i<4; i++) {
        *imgPath[i] = "";
        imgBtnPrev[i]->setText(tr("Image ") + QString::number(i+1));
        imgBtnPrev[i]->setStyleSheet("color: black; border-image: url(:/images/select"
                                     + QString::number(i+1)
                                     + ".png);");
        copyToBtn[i]->setVisible(false);
    }
    // saveBtn
    updateSaveBtn();
}
//********* END fourImages public slots *******************
