#!/usr/bib/python

import pygst
pygst.require("0.10")

# BUG FIX: GObject.threads_init() from gi.repository doesn't work with pygst 0.10:
import gobject
gobject.threads_init()

import gst 
import urllib2

class PlaylistParser:

    def get_track_list(self, playlistUrl):
        if playlistUrl.endswith("m3u"):
            if playlistUrl.startswith("http:"):
                response = urllib2.urlopen(playlistUrl)
                return self.parse(response)
            else:
                file = open(playlistUrl)
                return self.parse(file)
        
    def parse(self, lines):
        playlist = []
        for line in lines.readlines():
            line = line.strip()
            if line.startswith('#EXTINF:'):
                continue
            elif (len(line) != 0):
                playlist.append(line)
        return playlist

class AudioPlayer:

    def __init__(self):
        self.pipeline = gst.Pipeline("pipeline")
    
    def play_stream(self, stream):
        self.pipeline = gst.parse_launch("souphttpsrc location=" + stream + " ! decodebin ! pulsesink")
        self.pipeline.set_state(gst.STATE_PLAYING)
        #gobject.timeout_add(30000, self.stop)

    def bus_mp3(self, bus, message):
        t = message.type
        if t == gst.MESSAGE_EOS: 
            print "End Of Stream"
            self.next_mp3_track()
        elif t == gst.MESSAGE_ERROR:
            err, debug = message.parse_error()
            print "Error: %s" % err, debug	 

    def next_mp3_track(self):
        self.src.set_state(gst.STATE_NULL)
        self.pipeline.set_state(gst.STATE_NULL)
        self.src.unlink(self.mp3parser)
        self.mp3parser.unlink(self.mp3decoder)
        self.mp3decoder.unlink(self.audiosink)
        if self.trackIndex + 1 < len(self.tracks):
            self.trackIndex += 1
        else:
            trackIndex = 0
        self.play_mp3_track()
	
    def play_mp3_list(self, tracks):
        self.mp3parser = gst.element_factory_make("mp3parse", "mp3parse")
        self.mp3decoder = gst.element_factory_make("nokiamp3dec", "nokiamp3dec")
        self.audiosink = gst.element_factory_make("pulsesink", "pulsesink")
        self.pipeline.add(self.mp3parser)
        self.pipeline.add(self.mp3decoder)
        self.pipeline.add(self.audiosink)
        self.tracks = tracks
        self.trackIndex = 0
        self.play_mp3_track()

    def play_mp3_track(self):
        self.src = gst.element_factory_make("filesrc")
        self.src.set_property("location", self.tracks[self.trackIndex])
        self.pipeline.add(self.src)

        self.src.link(self.mp3parser)
        self.mp3parser.link(self.mp3decoder)
        self.mp3decoder.link(self.audiosink)
        
        bus = self.pipeline.get_bus()
	bus.add_signal_watch()
	bus.connect("message", self.bus_mp3)

        self.pipeline.set_state(gst.STATE_PLAYING)

    def stop(self):
        print "stop"
        self.pipeline.set_state(gst.STATE_NULL)

    def play(self, soundPath):
        if soundPath.endswith("m3u"):
            parser = PlaylistParser()
            list = parser.get_track_list(soundPath)
            if soundPath.startswith("http"):
                self.play_stream(list[0])
            else:
                self.play_mp3_list(list)
        else:
            if soundPath.startswith("http"):
                self.play_stream(soundPath)
