#!/usr/bin/python

from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QTabWidget, QColor, QPalette, QLabel, QPixmap, QStandardItemModel, QStandardItem

class ConfigDialog(QtGui.QDialog):
    """
    The configuration dialog
    """
 
    def __init__(self, parent=None):
        super(ConfigDialog, self).__init__(parent)

        self.setWindowTitle("Configuration")
        self.parent = parent
        self.alarms = AlarmsTab(parent)
        self.settings = SettingsTab(parent)
        self.sounds = SoundsTab(parent)
        self.themes = ThemesTab(parent)
        self.about = AboutTab(parent)

        tabWidget = QtGui.QTabWidget()
        tabWidget.addTab(self.settings, "Settings")
	tabWidget.addTab(self.alarms, "Alarm")
        tabWidget.addTab(self.sounds, "Sounds")
        tabWidget.addTab(self.themes, "Themes")
        tabWidget.addTab(self.about, "About")

        okButton = QtGui.QPushButton("&Ok")
        okButton.clicked.connect(self.doOk)

        layout = QtGui.QVBoxLayout()
        layout.addWidget(tabWidget)
        layout.addWidget(okButton)
        self.setLayout(layout)

    def doOk(self):
        self.parent.configuration.set("Settings", "fullscreen", str(self.settings.fullscreenCheckBox.isChecked()))
        self.parent.configuration.set("Settings", "screenAlwaysOn", str(self.settings.screenOnCheckBox.isChecked()))
        self.parent.configuration.set("Settings", "showDate", str(self.settings.showDateBox.isChecked()))
        self.parent.configuration.set("Settings", "soundPath", str(self.sounds.path.text()))
        self.parent.configuration.set("Settings", "autostopalarm", str(self.settings.autoStopAlarmCheckBox.isChecked()))
        self.parent.configuration.set("Settings", "themePath", str(self.themes.path.text()))
        self.parent.soundPath = self.sounds.path.text()
        self.accept()

class SettingsTab(QtGui.QWidget):
    """
    Tab for general settings
    """
    
    def __init__(self, p, parent=None):
        super(SettingsTab, self).__init__(parent)

        self.parent = p
        self.fullscreenCheckBox = QtGui.QCheckBox("Fullscreen")
        self.fullscreenCheckBox.setChecked(self.parent.configuration.getboolean("Settings", "fullscreen"))
        self.screenOnCheckBox = QtGui.QCheckBox("Screen always on")
        self.screenOnCheckBox.setChecked(self.parent.configuration.getboolean("Settings", "screenAlwaysOn"))
        self.showDateBox = QtGui.QCheckBox("Display date")
        self.showDateBox.setChecked(self.parent.configuration.getboolean("Settings", "showDate"))
        self.autoStopAlarmCheckBox = QtGui.QCheckBox("Turn Alarm off after 60 Mimutes")
        self.autoStopAlarmCheckBox.setChecked(self.parent.configuration.getboolean("Settings", "autostopalarm"))
        
        layout = QtGui.QVBoxLayout()
        layout.addWidget(self.fullscreenCheckBox)
        layout.addWidget(self.screenOnCheckBox)
        layout.addWidget(self.showDateBox)
        layout.addWidget(self.autoStopAlarmCheckBox)
        self.setLayout(layout)

class AlarmsDialog(QtGui.QDialog):

    def save(self):
      if self.hourWidget.currentRow() >= 0 and self.minWidget.currentRow() >= 0 and str(self.name.text()) not in self.parent.parent.alarmManager.events:
	weekDays = ""
	if self.mon.isChecked():
	    weekDays += "0,"
	if self.tue.isChecked():
            weekDays += "1,"
        if self.wed.isChecked():
            weekDays += "2,"
        if self.thu.isChecked():
            weekDays += "3,"
        if self.fri.isChecked():
            weekDays += "4,"
        if self.sat.isChecked():
            weekDays += "5,"
	if self.sun.isChecked():
            weekDays += "6,"

        hour = self.hourWidget.currentRow()
        if hour < 10:
            time = "0" + str(hour)
        else:
            time = str(hour)

        minute = self.minWidget.currentRow()
        if minute < 10:
            time = time + ":0" + str(minute)
        else:
            time = time + ":" + str(minute)
        
	self.parent.parent.alarmManager.add_event(str(self.name.text()), weekDays, time)

        self.parent.load_alarm_list()
        self.accept()

    def __init__(self, parent=None):
	self.parent = parent
        super(AlarmsDialog, self).__init__(parent)
        mainLayout = QtGui.QVBoxLayout()
        timeLayout = QtGui.QHBoxLayout()
        dayLayout = QtGui.QHBoxLayout()

        self.name = QtGui.QLineEdit()
        self.name.setText("Alarm " + str(len(self.parent.parent.alarmManager.events) + 1))
        
        self.mon = QtGui.QCheckBox("M.")
        self.tue = QtGui.QCheckBox("T.")
        self.wed = QtGui.QCheckBox("W.")
        self.thu = QtGui.QCheckBox("T.")
        self.fri = QtGui.QCheckBox("F.")
        self.sat = QtGui.QCheckBox("S.")
        self.sat.setStyleSheet("color: #FF6666")
        self.sun = QtGui.QCheckBox("S.")
        self.sun.setStyleSheet("color: #FF6666")

	self.hourWidget = QtGui.QListWidget()
        for i in range(23, -1, -1):
            text = str(i)    
            if i < 10:
                text = "0" + text
            item = QtGui.QListWidgetItem()
            item.setText(text);
            self.hourWidget.insertItem(0, item);
        self.hourWidget.setMinimumSize(150, 150)
        self.minWidget = QtGui.QListWidget()
        for i in range(59, -1, -1):
            text = str(i)    
            if i < 10:
                text = "0" + text
            item = QtGui.QListWidgetItem()
            item.setText(text);
            self.minWidget.insertItem(0, item);
        okButton = QtGui.QPushButton("&Ok")
        okButton.clicked.connect(self.save)

	mainLayout.addWidget(self.name)
    	timeLayout.addWidget(self.hourWidget)
	timeLayout.addWidget(self.minWidget)
        mainLayout.addLayout(timeLayout)
        dayLayout.addWidget(self.mon)
        dayLayout.addWidget(self.tue)
        dayLayout.addWidget(self.wed)
        dayLayout.addWidget(self.thu)
        dayLayout.addWidget(self.fri)
        dayLayout.addWidget(self.sat)
        dayLayout.addWidget(self.sun)
        mainLayout.addLayout(dayLayout)
	mainLayout.addWidget(okButton)

        self.setLayout(mainLayout)

class AlarmsTab(QtGui.QWidget):
    """
    Tab for alarm settings
    """
    def openNewAlarmDialog(self):
        dia = AlarmsDialog(self)
        dia.show()

    def edit(self):
        print "Edit" + str(self.listWidget.currentRow())
 
    def delete(self):
        text = str(self.listWidget.item(self.listWidget.currentRow()).text())
        key = text.split(" | ")[0]
        self.parent.alarmManager.remove_event(key)
        self.load_alarm_list()

    def load_alarm_list(self):
        self.listWidget.clear()
        for event in self.parent.alarmManager.events:
            item = QtGui.QListWidgetItem()
            text = str(event)
            text += " | " + self.parent.alarmManager.events[event]["Time"]
            weekDays = self.parent.alarmManager.events[event]["WeekDays"];
            text += " | "
            if "0" in weekDays:
                text += "Mo. "
            if "1" in weekDays:
                text += "Tu. "
            if "2" in weekDays:
                text += "We. "
            if "3" in weekDays:
                text += "Th. "
            if "4" in weekDays:
                text += "Fr. "
            if "5" in weekDays:
                text += "Sa. "
            if "6" in weekDays:
                text += "So. "
            item.setText(text)
            self.listWidget.insertItem(0, item);

    def __init__(self, p, parent=None):
        super(AlarmsTab, self).__init__(parent)

        self.parent = p

        newAlarmButton = QtGui.QPushButton("New Alarm")
        self.connect(newAlarmButton, QtCore.SIGNAL("clicked()"), self.openNewAlarmDialog)

        self.listWidget = QtGui.QListWidget()
        self.listWidget.setContextMenuPolicy(QtCore.Qt.ActionsContextMenu)
        #actionEdit = QtGui.QAction("Edit", self.listWidget)
        #actionEdit.triggered.connect(self.edit)
        actionDelete = QtGui.QAction("Delete", self.listWidget)
        actionDelete.triggered.connect(self.delete)
        #self.listWidget.addAction(actionEdit)
        self.listWidget.addAction(actionDelete)
        
        self.load_alarm_list()

        layout = QtGui.QVBoxLayout()
        layout.addWidget(newAlarmButton)
        layout.addWidget(self.listWidget)
        self.setLayout(layout)


class SoundsTab(QtGui.QWidget):
    """
    Tab for sound settings
    """

    def __init__(self, p, parent=None):
        super(SoundsTab, self).__init__(parent)

        self.parent = p

        label = QtGui.QLabel("Stream-URL(http) or Playlist(.m3u):")
        self.path = QtGui.QLineEdit()
        self.path.setText(self.parent.configuration.get("Settings", "soundPath"))
        button = QtGui.QPushButton("Choose Playlist(.m3u)")
        button.clicked.connect(self.openDialog)

        layout = QtGui.QVBoxLayout()
        layout.addWidget(label)
        layout.addWidget(self.path)
        layout.addWidget(button)
        self.setLayout(layout)

    def openDialog(self):
        options = QtGui.QFileDialog.Options()
        fileName = QtGui.QFileDialog.getOpenFileName(self,
            "Choose Stream-URL(http) or Playlist(.m3u)", "/", "Playlists (*.m3u)")
        if fileName:
            self.path.setText(fileName)

class ThemesTab(QtGui.QWidget):
    """
    Tab for theme settings
    """

    def __init__(self, p, parent=None):
        super(ThemesTab, self).__init__(parent)

        self.parent = p

        self.path = QtGui.QLineEdit()
        self.path.setText(self.parent.configuration.get("Settings", "themePath"))
        button = QtGui.QPushButton("Choose Directory containing the theme")
        button.clicked.connect(self.openDialog)

        layout = QtGui.QVBoxLayout()
        layout.addWidget(self.path)
        layout.addWidget(button)
        self.setLayout(layout)

    def openDialog(self):
        options = QtGui.QFileDialog.Options()
        fileName = QtGui.QFileDialog.getExistingDirectory(self,
            "Choose Directory containing the theme", "/")
        if fileName:
            self.path.setText(fileName)

class AboutTab(QtGui.QWidget):
    """
    Tab for about information
    """

    def __init__(self, p, parent=None):
        super(AboutTab, self).__init__(parent)

        self.parent = p

        self.text = QtGui.QTextEdit()
        self.text.setReadOnly(True)
        from __init__ import __version__, __author__
        self.text.setText("Wakeupcall " + str(__version__) +"\nWritten by " + str(__author__) + "\n2010 - 2015")
        self.text.setStyleSheet("background-color: rgb(0, 0, 0); color: rgb(255, 255, 255); border: None")
        
        layout = QtGui.QVBoxLayout()
        layout.addWidget(self.text)
        self.setLayout(layout)

