#!/usr/bin/env python

# -*- coding: utf-8 -*-
#
# Wakeupcall
# Copyright (c) 2010 Sebastian Glahn
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import sys, os
import glob
import re
from distutils.core import setup

sys.path.insert(0, 'src')
import wakeupcall 
      
inst_desktop = [ 'data/Wakeupcall.desktop' ]
inst_icon_64 = [ 'data/64x64/wakeupcall.png' ]
inst_binaries = [ 	'data/images/number0.png', 
			'data/images/number1.png', 
			'data/images/number2.png', 
			'data/images/number3.png',
			'data/images/number4.png', 
			'data/images/number5.png', 
			'data/images/number6.png', 
			'data/images/number7.png', 
			'data/images/number8.png',
			'data/images/number9.png',
			'data/images/dotOn.png',
			'data/images/dotOut.png',
			'data/images/quit.png',
			'data/images/conf.png'
		]
config_file = [ 'data/wakeupcall.config.ini.template' ]

data_files = [
    ('share/applications/hildon', inst_desktop),
    ('share/icons/hicolor/64x64/hildon', inst_icon_64),
    ('share/wakeupcall/default', inst_binaries),
    ('share/wakeupcall/', config_file),
]

packages = [
  'wakeupcall',
]

author, email = re.match(r'^(.*) <(.*)>$', wakeupcall.__author__).groups()

setup(
  name             = 'wakeupcall',
  version          = wakeupcall.__version__,
  package_dir      = { '':'src' },
  packages         = packages,
  description      = 'Themable Nightstand Alarm Clock',
  long_description = 'Themable Nightstand Alarm CLock',
  author           = author,
  author_email     = email,
  url              = wakeupcall.__url__,
  scripts          = glob.glob('bin/*'),
  data_files       = data_files
)

