#ifndef _RULES_H_
#define _RULES_H_

#include <string>
#include <vector>

using namespace std;
class ManaCost;
class Player;
class MTGPlayerCards;
class MTGDeck;
class MTGCardInstance;

#define MAX_RULES_CARDS 4096;

class RulesPlayerZone
{
public:
    vector<int> cards;
    void add(int cardid);
    RulesPlayerZone();
    void cleanup();
};

class RulesPlayerData
{
public:
    vector<string> extraRules;
    string phaseRing;
	int offerInterruptOnPhase;
    int life;
    int poisonCount;
    int damageCount;
    int preventable;
    string avatar;
    ManaCost * manapool;
    RulesPlayerZone zones[5];
    RulesPlayerData();
    ~RulesPlayerData();
    void cleanup();

};

class RulesState
{
public:
    int phase;
    int player;
    void parsePlayerState(int playerId, string s);
    RulesState();
    RulesPlayerData playerData[2];
    void cleanup();
};

class Rules
{
protected:
    Player * loadPlayerMomir(int isAI);
    Player * loadPlayerRandom(int isAI, int mode);
    Player * initPlayer(int playerId);
    MTGDeck * buildDeck(int playerId);
    int strToGameMode(string s);
    bool postUpdateInitDone;
public:
    enum
    {
        PARSE_UNDEFINED,
        PARSE_INIT,
        PARSE_PLAYER1,
        PARSE_PLAYER2,
        PARSE_PLAYERS
    };

    string bg;
	string filename;
    int gamemode;
    bool hidden;
	string displayName;
	int unlockOption;
	static vector<Rules *> RulesList;

    Rules(string bg = "");
    int load(string _filename);
	static int loadAllRules();
    static void unloadAllRules();
    static Rules * getRulesByFilename(string _filename);
    void initPlayers();
    bool canChooseDeck(); //True if the players get to select their decks, false if the decks are automatically generated by the mode
    void addExtraRules();
    void initGame();
    //second part of the initialization, needs to happen after the first update call
    void postUpdateInit();
    void cleanup();
    vector<string> extraRules;
    RulesState initState;
    static int getMTGId(string name);
    static MTGCardInstance * getCardByMTGId(int mtgid);

};



#endif
