#!/usr/bin/env python

import sys, pygame, time
import pygame.mixer 
from PyQt4 import QtCore
from PyQt4 import QtGui
from pygame.locals import *

#Initiate Pygame sound mixers                   
pygame.mixer.init() 
pygame.init()

#Location of the Vuvuzela Wav file
vuvusound = pygame.mixer.Sound("/opt/vuvuzela/sounds/V.wav")
   
class Vuvu(QtGui.QWidget):
    def __init__(self, parent=None):
        
        QtGui.QWidget.__init__(self, parent)
        
        self.color = QtGui.QColor(0, 0, 0) 
        self.setGeometry(300, 300, 800, 480)
        self.setWindowTitle('Vuvuzela')
        
        self.square = QtGui.QWidget(self)
        self.square.setGeometry(0, 0, 800, 480)       
        
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

        #Set up initial Vuvuzela picture
        vuvupic = QtGui.QPixmap("/opt/vuvuzela/images/White.png")
        self.label = QtGui.QLabel(self)
        self.label.setPixmap(vuvupic)
        self.label.move(100, 100)
        
        #Buttons to control background colour
        self.red = QtGui.QPushButton('Red', self)
        self.red.setGeometry(0, 350, 120, 70)
        self.connect(self.red, QtCore.SIGNAL('clicked()'), self.setRed)
        
        self.blue = QtGui.QPushButton('Blue', self)
        self.blue.setGeometry(137, 350, 120, 70)
        self.connect(self.blue, QtCore.SIGNAL('clicked()'), self.setBlue)
        
        self.green = QtGui.QPushButton('Green', self)
        self.green.setGeometry(270, 350, 120, 70)
        self.connect(self.green, QtCore.SIGNAL('clicked()'), self.setGreen)
        
        self.yellow = QtGui.QPushButton('Yellow', self)
        self.yellow.setGeometry(403, 350, 120, 70)
        self.connect(self.yellow, QtCore.SIGNAL('clicked()'), self.setYellow)
        
        self.pink = QtGui.QPushButton('Pink', self)
        self.pink.setGeometry(536, 350, 120, 70)
        self.connect(self.pink, QtCore.SIGNAL('clicked()'), self.setPink)
        
        self.white = QtGui.QPushButton('White', self)
        self.white.setGeometry(669, 350, 120, 70)
        self.connect(self.white, QtCore.SIGNAL('clicked()'), self.setWhite)
        
    
        #Definining the Play & Stop buttions

        self.button1 = QtGui.QPushButton("Start", self)
        self.button1.setGeometry(100, 200, 100, 70)
        QtCore.QObject.connect(self.button1, QtCore.SIGNAL('clicked()'), self.playSong) 

        self.button2 = QtGui.QPushButton("Stop", self)
        self.button2.setGeometry(600, 200, 100, 70)
        QtCore.QObject.connect(self.button2, QtCore.SIGNAL('clicked()'), self.stopSong)
         
        self.button3 = QtGui.QPushButton("Press to Start / Stop", self)
        self.button3.setCheckable(True)
        self.button3.setGeometry(200, 200, 400, 70)
        QtCore.QObject.connect(self.button3, QtCore.SIGNAL('clicked()'), self.holdToPlay)
        
        
        #Buttons to control the coulours of the Vuvuzela
        self.redvuvu = QtGui.QPushButton('Red \nVuvu', self)
        self.redvuvu.setGeometry(0, 0, 120, 70)
        self.connect(self.redvuvu, QtCore.SIGNAL('clicked()'), self.setVuvuRed)
        
        self.bluevuvu = QtGui.QPushButton('Blue \nVuvu', self)
        self.bluevuvu.setGeometry(137, 0, 120, 70)
        self.connect(self.bluevuvu, QtCore.SIGNAL('clicked()'), self.setVuvuBlue)
        
        self.greenvuvu = QtGui.QPushButton('Green \nVuvu', self)
        self.greenvuvu.setGeometry(270, 0, 120, 70)
        self.connect(self.greenvuvu, QtCore.SIGNAL('clicked()'), self.setVuvuGreen)
        
        self.yellowvuvu = QtGui.QPushButton('Yellow \nVuvu', self)
        self.yellowvuvu.setGeometry(403, 0, 120, 70)
        self.connect(self.yellowvuvu, QtCore.SIGNAL('clicked()'), self.setVuvuYellow)
        
        self.pinkvuvu = QtGui.QPushButton('Pink \nVuvu', self)
        self.pinkvuvu.setGeometry(536, 0, 120, 70)
        self.connect(self.pinkvuvu, QtCore.SIGNAL('clicked()'), self.setVuvuPink)
        
        self.whitevuvu = QtGui.QPushButton('White \nVuvu', self)
        self.whitevuvu.setGeometry(669, 0, 120, 70)
        self.connect(self.whitevuvu, QtCore.SIGNAL('clicked()'), self.setVuvuWhite)
        
        
        #Definitions to change the background colours          
    def setRed(self):
        self.color.setBlue(0)
        self.color.setGreen(0)
        self.color.setRed(255)
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setGreen(self):
        self.color.setBlue(0)
        self.color.setGreen(250)
        self.color.setRed(0)
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

    def setBlue(self):
        self.color.setBlue(255)
        self.color.setGreen(0)
        self.color.setRed(0)
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setYellow(self):
        self.color.setBlue(0)
        self.color.setGreen(255)
        self.color.setRed(255)
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setPink(self):
        self.color.setBlue(255)
        self.color.setGreen(0)
        self.color.setRed(255)
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setWhite(self):
        self.color.setBlue(255)
        self.color.setGreen(255)
        self.color.setRed(255)
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
        
        #Buttons to control the colours of the Vuvuzelas
    def setVuvuGreen(self):
        vuvupicgreen = QtGui.QPixmap("/opt/vuvuzela/images/Green.png")
        self.label.setPixmap(vuvupicgreen)
        print "Green"
        
    def setVuvuBlue(self):
        vuvupicblue = QtGui.QPixmap("/opt/vuvuzela/images/Blue.png")
        self.label.setPixmap(vuvupicblue)
        print "Blue"
        
    def setVuvuRed(self):
        vuvupicred = QtGui.QPixmap("/opt/vuvuzela/images/Red.png")
        self.label.setPixmap(vuvupicred)
        print "Red"
        
    def setVuvuWhite(self):
        vuvupicwhite = QtGui.QPixmap("/opt/vuvuzela/images/White.png")
        self.label.setPixmap(vuvupicwhite)
        print "White"
 
    def setVuvuYellow(self):
        vuvupicyellow = QtGui.QPixmap("/opt/vuvuzela/images/Yellow.png")
        self.label.setPixmap(vuvupicyellow)
        print "Yellow"
        
    def setVuvuPink(self):
        vuvupicpink = QtGui.QPixmap("/opt/vuvuzela/images/Pink.png")
        self.label.setPixmap(vuvupicpink)
        print "Pink"
 
 
        #Definitions to control the sound playing        
    def playSong(self):
        print "Vuvu Started!"
        vuvusound.play(loops=5, maxtime=0, fade_ms=0)
        time.sleep(.1)
    
    def stopSong(self):
        print "Vuvu Stopped"
        pygame.mixer.stop()
        
    def holdToPlay(self):
        if self.button3.isChecked():
            vuvusound.play()
            time.sleep(.1)
            print"Vuvuzela looped by hold button"
        else: 
            pygame.mixer.stop()
            print "Hold Stoped"
            

app = QtGui.QApplication(sys.argv)
vv = Vuvu()
vv.show()
app.exec_()