#!/usr/bin/env python

import sys, pygame, time
import pygame.mixer 
from PyQt4 import QtCore
from PyQt4 import QtGui
from pygame.locals import *
   
                              
pygame.mixer.init() 
pygame.init()

#Location of the Vuvuzela Wav file
vuvusound = pygame.mixer.Sound("/opt/Vuvuzela/sounds/V.wav")

#Definitions to set up the sound playing
def playSong():
    print "Vuvu Started!"
    vuvusound.play(loops=3, maxtime=0, fade_ms=0)
    time.sleep(.1)
    
def stopSong():
    print "Vuvu Stopped"
    pygame.mixer.stop()


class Vuvuzela(QtGui.QWidget):
    def __init__(self, parent=None):
        
        QtGui.QWidget.__init__(self, parent)
        
        self.color = QtGui.QColor(0, 0, 0) 
        
        self.setGeometry(300, 300, 800, 480)
        self.setWindowTitle('Vuvuzela')
        
        self.square = QtGui.QWidget(self)
        self.square.setGeometry(0, 0, 800, 480)       
        
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

        vuvupic = QtGui.QPixmap("/opt/Vuvuzela/images/Vuvuzela.png")
        label = QtGui.QLabel(self)
        label.setPixmap(vuvupic)
        label.move(103, 100)
        
        self.red = QtGui.QPushButton('Red', self)
        #self.red.setCheckable(True)
        self.red.setGeometry(0, 350, 120, 70)
        self.connect(self.red, QtCore.SIGNAL('clicked()'), self.setRed)
        
        self.blue = QtGui.QPushButton('Blue', self)
        #self.blue.setCheckable(True)
        self.blue.setGeometry(137, 350, 120, 70)
        self.connect(self.blue, QtCore.SIGNAL('clicked()'), self.setBlue)
        
        self.green = QtGui.QPushButton('Green', self)
        #self.green.setCheckable(True)
        self.green.setGeometry(270, 350, 120, 70)
        self.connect(self.green, QtCore.SIGNAL('clicked()'), self.setGreen)
        
        self.yellow = QtGui.QPushButton('Yellow', self)
        #self.green.setCheckable(True)
        self.yellow.setGeometry(403, 350, 120, 70)
        self.connect(self.yellow, QtCore.SIGNAL('clicked()'), self.setYellow)
        
        self.pink = QtGui.QPushButton('Pink', self)
        #self.green.setCheckable(True)
        self.pink.setGeometry(536, 350, 120, 70)
        self.connect(self.pink, QtCore.SIGNAL('clicked()'), self.setPink)
        
        self.white = QtGui.QPushButton('White', self)
        #self.green.setCheckable(True)
        self.white.setGeometry(669, 350, 120, 70)
        self.connect(self.white, QtCore.SIGNAL('clicked()'), self.setWhite)
        
                
        #Definining the Play & Stop buttions
        button1 = QtGui.QPushButton("Start Vuvuzela", self)
        button1.setGeometry(200, 200, 200, 70)
        QtCore.QObject.connect(button1, QtCore.SIGNAL('clicked()'), playSong) 
        
        button2 = QtGui.QPushButton("Stop Vuvuzela", self)
        button2.setGeometry(400, 200, 200, 70)
        QtCore.QObject.connect(button2, QtCore.SIGNAL('clicked()'), stopSong)
        
                
    def setRed(self):
        self.color.setBlue(0)
        self.color.setGreen(0)
        self.color.setRed(255)

        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setGreen(self):
        self.color.setBlue(0)
        self.color.setGreen(250)
        self.color.setRed(0)
        
        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

    def setBlue(self):
        self.color.setBlue(255)
        self.color.setGreen(0)
        self.color.setRed(0)

        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setYellow(self):
        self.color.setBlue(0)
        self.color.setGreen(255)
        self.color.setRed(255)

        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
        
    def setPink(self):
        self.color.setBlue(255)
        self.color.setGreen(0)
        self.color.setRed(255)

        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
    def setWhite(self):
        self.color.setBlue(255)
        self.color.setGreen(255)
        self.color.setRed(255)

        self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
        
        
        
app = QtGui.QApplication(sys.argv)
vv = Vuvuzela()
vv.show()
app.exec_()