#include "settingsdialog.h"
#include "ui_settingsdialog.h"

#include <QSettings>

QString SettingsDialog::AUTO_ROTATE = "auto_rotate";
QString SettingsDialog::COLOR_SCALE = "color_scale";
QString SettingsDialog::TRIGGER = "trigger";
QString SettingsDialog::TRIGGER_COMMAND = SettingsDialog::TRIGGER + "/command";
QString SettingsDialog::TRIGGER_COUNT = SettingsDialog::TRIGGER + "/count";
QString SettingsDialog::TRIGGER_VALUE = SettingsDialog::TRIGGER + "/value";

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    QSettings settings;

    ui->triggerValueEdit->setValue(settings.value(SettingsDialog::TRIGGER_VALUE, 0).toInt());
    ui->triggerCommandEdit->setText(settings.value(SettingsDialog::TRIGGER_COMMAND, "").toString());
    ui->triggerCountEdit->setValue(settings.value(SettingsDialog::TRIGGER_COUNT, 0).toInt());

#ifdef Q_WS_MAEMO_5
    ui->autoRotateCheckBox->setChecked(settings.value(SettingsDialog::AUTO_ROTATE, false).toBool());
#else
    ui->autoRotateCheckBox->close();
    ui->autoRotateLabel->close();
#endif

    ui->colorScaleSettingCheckBox->setChecked(settings.value(SettingsDialog::COLOR_SCALE, false).toBool());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept(){
    QSettings settings;

    settings.setValue(SettingsDialog::TRIGGER_VALUE, ui->triggerValueEdit->value());
    settings.setValue(SettingsDialog::TRIGGER_COMMAND, ui->triggerCommandEdit->text());
    settings.setValue(SettingsDialog::TRIGGER_COUNT, ui->triggerCountEdit->value());

#ifdef Q_WS_MAEMO_5
    settings.setValue(SettingsDialog::AUTO_ROTATE, ui->autoRotateCheckBox->checkState());
#endif

    settings.setValue(SettingsDialog::COLOR_SCALE, ui->colorScaleSettingCheckBox->checkState());

    settings.sync();

    done(1);
}
