/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VOLUMEMETERWIDGET_H
#define VOLUMEMETERWIDGET_H

#include <QImage>
#include <QPainter>
#include <QtOpenGL/QGLWidget>

#define MAX_DB 110
#define MAX_LINEAR 200
#define RATIO 3.

class VolumeMeterWidget : public QGLWidget
{
    Q_OBJECT
public:
    explicit VolumeMeterWidget(QWidget *parent = 0);

    virtual void updateValue(int value);
    virtual void setDbUnit(bool b);

signals:
    void clicked();

protected:
    QImage *background;
    int currentValue;
    bool dbUnit;

    virtual void draw(QPainter *painter) = 0;
    virtual void initPainter(QPainter *painter);
    void mouseReleaseEvent(QMouseEvent *);
    virtual void paintEvent(QPaintEvent *event);
    virtual void resizeEvent(QResizeEvent *event);
};

#endif // VOLUMEMETERWIDGET_H
