/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "volumemeterwidget.h"

#include <QPen>
#include <QRect>

VolumeMeterWidget::VolumeMeterWidget(QWidget *parent) :
    QWidget(parent)
{
    currentValue = 0;
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}

void VolumeMeterWidget::setDbUnit(bool b){
    dbUnit = b;
    currentValue = 0;
    emit update();
}

void VolumeMeterWidget::updateValue(int value){
    currentValue = value;
    emit update();
}

void VolumeMeterWidget::mouseReleaseEvent(QMouseEvent */*event*/){
    emit clicked();
}
