/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "horizontalvolumebarwidget.h"

HorizontalVolumeBarWidget::HorizontalVolumeBarWidget(QWidget *parent) : VolumeMeterWidget(parent)
{
}

void HorizontalVolumeBarWidget::paintEvent(QPaintEvent */*event*/){
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    painter.setViewport(0, 0, width(), height());
    painter.setWindow(0, 0, 300, 100);

    draw(& painter);
}

void HorizontalVolumeBarWidget::draw(QPainter *painter){
#ifdef Q_WS_MAEMO_5
    QRectF background(0, 0, 300, 100);
    painter->fillRect(background, QBrush(Qt::white));

    QFont font = painter->font();
    font.setPointSizeF(font.pointSizeF()*0.6);
    painter->setFont(font);
#endif
    QPen finePen(Qt::black);
    finePen.setWidth(1);

    QPen thinPen(Qt::black);
    thinPen.setWidth(2);

    QPen thickPen(Qt::black);
    thickPen.setWidth(4);

    painter->setPen(finePen);

    QRectF chartBackground(2, 2, 296, 70);
    painter->drawRect(chartBackground);

    float vol;
    if(dbUnit){
        vol = ((float) currentValue) / MAX_DB;

        for(int i = 0; i <= (MAX_DB / 10); i++){
            float x = 296 / (MAX_DB / 10.)*i;

            if(i % 2 == 0){
                painter->setPen(thickPen);
                painter->drawLine(4+x, 74, 4+x, 80);

                painter->setPen(thinPen);
                if(i > 0){
                    x -= 4;
                }
                if(i >= 10){
                    x -= 4;
                }

                painter->drawText(x, 96, QString().setNum(i*10));
            }else{
                painter->setPen(thinPen);

                if(i < 11){
                    painter->drawLine(4+x, 73, 4+x, 77);
                }else{
                    painter->drawLine(1+x, 73, 1+x, 77);
                }
            }
        }
    }else{
        vol = ((float) currentValue) / MAX_LINEAR;

        for(int i = 0; i <= (MAX_LINEAR / 10); i++){
            float x = 296 / (MAX_LINEAR / 10.)*i;

            if(i % 5 == 0){
                painter->setPen(thickPen);
                if(i < 20){
                    painter->drawLine(4+x, 74, 4+x, 80);

                    painter->setPen(thinPen);
                    if(i > 0){
                        x -= 4;
                    }
                    if(i >= 10){
                        x -= 4;
                    }

                    painter->drawText(x, 96, QString().setNum(i*10));
                }else{
                    painter->drawLine(x, 74, x, 80);
                }
            }else{
                painter->setPen(thinPen);
                painter->drawLine(4+x, 73, 4+x, 77);
            }
        }
    }

    QRectF scale(2, 2, 294 * vol, 70);
    painter->fillRect(scale, QBrush(Qt::darkBlue));
}
