/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

#include <QFileDialog>
#include <QPalette>
#include <QSettings>

QString SettingsDialog::AUTO_ROTATE = "auto_rotate";

QString SettingsDialog::COLOR_SCALE = "color_scale";
QString SettingsDialog::COLOR_LOWER_THRESHOLD = "color/lower_threshold";
QString SettingsDialog::COLOR_UPPER_THRESHOLD = "color/upper_threshold";
QString SettingsDialog::COLOR_LOWER_COLOR = "color/lower_color";
QString SettingsDialog::COLOR_MID_COLOR = "color/mid_color";
QString SettingsDialog::COLOR_UPPER_COLOR = "color/upper_color";

QString SettingsDialog::LOG_FILE_NAME = "log/file_name";
QString SettingsDialog::LOG_LOGGING_ENABLED = "log/enabled";

QString SettingsDialog::METER = "meter";

QString SettingsDialog::TRIGGER = "trigger";
QString SettingsDialog::TRIGGER_COMMAND = SettingsDialog::TRIGGER + "/command";
QString SettingsDialog::TRIGGER_COUNT = SettingsDialog::TRIGGER + "/count";
QString SettingsDialog::TRIGGER_VALUE = SettingsDialog::TRIGGER + "/value";

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    QSettings settings;

    ui->triggerValueEdit->setValue(settings.value(SettingsDialog::TRIGGER_VALUE, 0).toInt());
    ui->triggerCommandEdit->setText(settings.value(SettingsDialog::TRIGGER_COMMAND, "").toString());
    ui->triggerCountEdit->setValue(settings.value(SettingsDialog::TRIGGER_COUNT, 0).toInt());

#ifdef Q_WS_MAEMO_5
    ui->autoRotateCheckBox->setChecked(settings.value(SettingsDialog::AUTO_ROTATE, false).toBool());
#else
    ui->autoRotateCheckBox->close();
    ui->autoRotateLabel->close();
#endif

    ui->colorScaleSettingCheckBox->setChecked(settings.value(SettingsDialog::COLOR_SCALE, false).toBool());

    ui->lowerThresholdSpinBox->setValue(settings.value(SettingsDialog::COLOR_LOWER_THRESHOLD, 60).toInt());
    ui->upperThresholdSpinBox->setValue(settings.value(SettingsDialog::COLOR_UPPER_THRESHOLD, 95).toInt());

    ui->lowerColorPushButton->setColor(settings.value(SettingsDialog::COLOR_LOWER_COLOR, QColor(Qt::green)).value<QColor>());
    ui->midColorPushButton->setColor(settings.value(SettingsDialog::COLOR_MID_COLOR, QColor(Qt::yellow)).value<QColor>());
    ui->upperColorPushButton->setColor(settings.value(SettingsDialog::COLOR_UPPER_COLOR, QColor(Qt::red)).value<QColor>());

    ui->logDataSettingCheckBox->setChecked(settings.value(SettingsDialog::LOG_LOGGING_ENABLED, false).toBool());
    ui->logDataFileNameLineEdit->setText(settings.value(SettingsDialog::LOG_FILE_NAME, tr("Select File")).toString());
    connect(ui->logDataFileChooserPushButton, SIGNAL(clicked()), this, SLOT(openLogFileSelectionDialog()));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept(){
    QSettings settings;

    settings.setValue(SettingsDialog::TRIGGER_VALUE, ui->triggerValueEdit->value());
    settings.setValue(SettingsDialog::TRIGGER_COMMAND, ui->triggerCommandEdit->text());
    settings.setValue(SettingsDialog::TRIGGER_COUNT, ui->triggerCountEdit->value());

#ifdef Q_WS_MAEMO_5
    settings.setValue(SettingsDialog::AUTO_ROTATE, ui->autoRotateCheckBox->checkState());
#endif

    settings.setValue(SettingsDialog::COLOR_SCALE, ui->colorScaleSettingCheckBox->checkState());

    settings.setValue(SettingsDialog::COLOR_LOWER_THRESHOLD, ui->lowerThresholdSpinBox->value());
    settings.setValue(SettingsDialog::COLOR_UPPER_THRESHOLD, ui->upperThresholdSpinBox->value());

    settings.setValue(SettingsDialog::COLOR_LOWER_COLOR, ui->lowerColorPushButton->getColor());
    settings.setValue(SettingsDialog::COLOR_MID_COLOR, ui->midColorPushButton->getColor());
    settings.setValue(SettingsDialog::COLOR_UPPER_COLOR, ui->upperColorPushButton->getColor());

    settings.setValue(SettingsDialog::LOG_LOGGING_ENABLED, ui->logDataSettingCheckBox->isChecked());
    settings.setValue(SettingsDialog::LOG_FILE_NAME, ui->logDataFileNameLineEdit->text());

    settings.sync();

    done(1);
}

void SettingsDialog::openLogFileSelectionDialog(){
    QString currentFile;

    if(ui->logDataFileNameLineEdit == NULL
       || ui->logDataFileNameLineEdit->text().compare(tr("Select File")) == 0){
#ifdef Q_WS_MAEMO_5
        currentFile = QDir::home().absolutePath() + "/MyDocs";
#else
        currentFile = QDir::home().absolutePath();
#endif
    }else{
        currentFile = ui->logDataFileNameLineEdit->text();
    }

    QString newFile = QFileDialog::getSaveFileName(this, "Select log file.", currentFile);
    if(newFile != NULL){
        ui->logDataFileNameLineEdit->setText(newFile);
    }
}

