/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pa_utils.h"

#include <string.h>
#include <pulse/ext-stream-restore.h>

static bool availability_checked = false;
static bool is_available = false;
static char *source_name = NULL;

void get_source_info_list_callback(pa_context *context, const pa_source_info *info, int eol, void *data){
    (void) context;
    (void) data;

    if(eol == 0){
        qDebug("Source: %s Index: %d", info->name, info->index);
        if(source_name == NULL){
            qDebug("Using %s as source.", info->name);
            source_name = new char[strlen(info->name)];
            strcpy(source_name, info->name);
        }
    }else{
        qDebug("Sending signal...");
        pa_threaded_mainloop_signal(threaded_main_loop, 0);
    }
}

#ifndef Q_WS_MAEMO_5
const char *get_source_name(){
/*
    pa_context_get_source_info_list(context, get_source_info_list_callback, NULL);

    do{
        pa_threaded_mainloop_lock(threaded_main_loop);
        pa_threaded_mainloop_wait(threaded_main_loop);
        qDebug("Received signal...");
    }while(source_name == NULL);
    pa_threaded_mainloop_unlock(threaded_main_loop);

    qDebug("Got source: %s", source_name);
    return (const char*) source_name;
}
*/
    return "alsa_input.hw_0";
}
#else
const char *get_source_name(){
    return "source.hw0";
}
#endif

bool pa_available(){
    if(! availability_checked){
        int context_available;
        context_available = context_create();
        context_stop();

        is_available = (context_available == 0);
        availability_checked = true;
    }
    return is_available;
}
