/*
 * This file is part of vpngui
 *
 * Copyright © 2009 Nokia Corporation and/or its subsidiary(-ies)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include "vpn_notify.h"

static gboolean
vpn_notify_get_status (VpnNotify * self,
    gboolean * ret_up, gchar ** ret_ip, GError ** error);

#include "vpn_notify-glue.h"

#define VPN_NOTIFY_GET_PRIVATE(obj) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((obj), VPN_TYPE_NOTIFY, VpnNotifyPrivate))

typedef struct _VpnNotifyPrivate VpnNotifyPrivate;

struct _VpnNotifyPrivate
{
  gchar *ip;
};

enum {
  PROP_IP = 1,
};

G_DEFINE_TYPE (VpnNotify, vpn_notify, G_TYPE_OBJECT)

static void
vpn_notify_finalize (GObject * object)
{
  VpnNotifyPrivate *priv;

  g_debug ("%s", G_STRFUNC);

  g_assert (object);
  g_assert (VPN_IS_NOTIFY (object));
  priv = VPN_NOTIFY_GET_PRIVATE (object);
  g_assert (priv);

  g_free (priv->ip);
}

static void
vpn_notify_get_property (GObject * object,
    guint property_id, GValue * value, GParamSpec * pspec)
{
  VpnNotifyPrivate *priv;

  g_debug ("%s", G_STRFUNC);

  g_assert (object);
  g_assert (VPN_IS_NOTIFY (object));
  priv = VPN_NOTIFY_GET_PRIVATE (object);
  g_assert (priv);

  switch (property_id)
    {
      case PROP_IP:
        g_value_set_string (value, priv->ip);
        g_debug("ip = %s", priv->ip);
        break;
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static void
vpn_notify_set_property (GObject * object,
    guint property_id, const GValue * value, GParamSpec * pspec)
{
  VpnNotifyPrivate *priv;

  g_debug ("%s", G_STRFUNC);

  g_assert (object);
  g_assert (VPN_IS_NOTIFY (object));
  priv = VPN_NOTIFY_GET_PRIVATE (object);
  g_assert (priv);

  switch (property_id)
    {
      case PROP_IP:
        g_free (priv->ip);
        priv->ip = g_value_dup_string (value);
        g_debug("ip = %s", priv->ip);
        if (priv->ip[0] != '\0')
          g_signal_emit_by_name (object, "up", priv->ip);
        else
          g_signal_emit_by_name (object, "down");
        break;
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static void
vpn_notify_class_init (VpnNotifyClass * klass)
{
  GObjectClass *gobject_class;

  g_debug ("%s", G_STRFUNC);

  gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->finalize = vpn_notify_finalize;
  gobject_class->get_property = vpn_notify_get_property;
  gobject_class->set_property = vpn_notify_set_property;

  g_object_class_install_property (gobject_class,
      PROP_IP, g_param_spec_string ("ip",
          "IP address", "The local IP address", "", G_PARAM_READWRITE));

  g_signal_new ("up",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__STRING,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  g_signal_new ("down",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__VOID,
      G_TYPE_NONE,
      0);

  g_type_class_add_private (klass, sizeof (VpnNotifyPrivate));

  dbus_g_object_type_install_info (VPN_TYPE_NOTIFY,
      &dbus_glib_vpn_notify_object_info);
}

static void
vpn_notify_init (VpnNotify * self)
{
  VpnNotifyPrivate *priv;

  g_debug ("%s", G_STRFUNC);

  g_assert (self);
  g_assert (VPN_IS_NOTIFY (self));
  priv = VPN_NOTIFY_GET_PRIVATE (self);
  g_assert (priv);

  priv->ip = g_strdup ("");
}

static gboolean
vpn_notify_get_status (VpnNotify * self,
    gboolean * ret_up, gchar ** ret_ip, GError ** error)
{
  VpnNotifyPrivate *priv;

  g_debug ("%s", G_STRFUNC);

  g_assert (self);
  g_assert (VPN_IS_NOTIFY (self));
  priv = VPN_NOTIFY_GET_PRIVATE (self);
  g_assert (priv);

  *ret_up = priv->ip[0] != '\0';
  *ret_ip = g_strdup (priv->ip);

  g_debug ("%s: up = %d, ip = %s", G_STRFUNC, *ret_up, *ret_ip);

  return TRUE;
}
