/* maemo vpnc-gui
 * 
 * Copyright (c) 2007-2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* See also: https://garage.maemo.org/svn/maemoexamples/trunk/example_gconf.c
 */

/* IMPORTS */
#include <glib.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "profiles_gui_gconf.h"

#define GCONF_PATH "/apps/vpnc-gui/profiles"
#define GCONF_LAST_USED_KEY "last_used_profile"

/* (local) VARIABLES */
static GConfClient *client=NULL;

/* EXPORTS */

/**
 * Initialize gconf. This must be called
 * before any other function.
 */
void profiles_gui_gconf_init() {

	if(client!=NULL)
		return;
	
	/* Get the default client */
	client=gconf_client_get_default();
	
	/* Add GConf node if absent */
	gconf_client_add_dir(client, GCONF_PATH,
			GCONF_CLIENT_PRELOAD_NONE, NULL);

}

/**
 * Return the name of the last used profile.
 * Non-NULL result must be freed.
 * 
 * @return the profile-name as a g_malloced string or NULL of none saved
 */
gchar *profiles_gui_gconf_get_last_used_profile() {
	
        gchar *path=g_strconcat(GCONF_PATH, 
			"/", GCONF_LAST_USED_KEY, NULL);

	gchar *res=gconf_client_get_string(client, path, NULL);
	g_free(path);
	return res;
}

/**
 * Set the last used profile.
 * If profile is NULL then the gconf entry is removed.
 *
 * @param profile the profile-name as string or NULL
 * @return TRUE if saved successfully
 */
gboolean profiles_gui_gconf_set_last_used_profile(const gchar *profile) {
	gchar *path=g_strconcat(GCONF_PATH,
			"/", GCONF_LAST_USED_KEY, NULL);
	
	gboolean res;
	if(profile==NULL)
		res=gconf_client_unset(client, path, NULL);
	else
		res=gconf_client_set_string(client, path, profile, NULL);

	g_free(path);
	return res;
}

