/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#ifndef __PROFILE_H__
#define __PROFILE_H__

/** constant for vpnc profile */
#define PROFILE_TYPE_VPNC 0x1
/** constant for openvpn profile */
#define PROFILE_TYPE_OPENVPN 0x2

/** struct that describes a profile */
struct profile {

	/** the name of the profile */
	char *name;

	/** type of the profile, see constants above */
	int type;

	/** pointer to configuration data */
	void *config_data;
	
};

struct profile *profile_alloc();
void profile_free(struct profile *p);

#endif
