//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef SETTINGS_H
#define SETTINGS_H

#include <QObject>
#include <QSettings>
#include <QStringList>
#include "widget/saldopunti.h"
#include "widget/counter.h"

class Settings : public QObject
{
public:
    enum connections{
        connWLAN = 0,
        connGPRS,
        connBoth,
    };

    explicit Settings(QObject *parent = 0, QString appletId="");

    Counter::widgetSize CounterStyle;
    bool Animation;
    QString StyleSheetName;
    QString Username;
    QString Password;
    QStringList AllSIM;
    QString SIM;
    connections UpdateOn;
    bool ShowCredito;
    bool ShowPunti;
    QList<Counter*> ShowCounters;
    QList<Counter*> AllCounters;
    bool ShowLabels;
    bool ShowPercentage;
    int UpdateInterval;
    float LastCredito;
    QString LastValuta;
    SaldoPunti* LastSaldoPunti;
    int WidgetWidth;

    bool Load();
    bool Save();

    static void RemoveWidget(QString appletId);
    static QList<QString> GetAppletIds();
    static void SaveAppletIds(QList<QString> ids);

private:
    QString m_AppletId;
    static QString GetConfigName();

};

#endif // SETTINGS_H
