//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "counterwidget.h"
#include "commonstatic.h"
#include "qtitlelabel.h"

CounterWidget::CounterWidget(QWidget *parent, Counter* counter, Settings* settings) :
    QFrame(parent)
{    

    m_Counter = counter;

    m_Bar = NULL;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    setContentsMargins(0,0,0,0);

    m_Layout = new QGridLayout(this);
    m_Layout->setSpacing(3);
    m_Layout->setContentsMargins(0,0,0,0);
    this->setLayout(m_Layout);

    CreateWidgets(settings);
}

CounterWidget::~CounterWidget()
{
    delete m_Layout;
}

void CounterWidget::CreateWidgets(Settings* settings)
{
    int row = 0;
    if (settings->ShowLabels){
        QTitleLabel* titleLbl = new QTitleLabel(this);
        titleLbl->setWordWrap(true);
        titleLbl->setText(m_Counter->Description);
        m_Layout->addWidget(titleLbl, row, 0, 1, 2);
        row++;
    }
#ifdef Q_OS_SYMBIAN
    QString util = tr("Traff. util.:");
#else
    QString util = tr("Traff. utilizzato:");
#endif
    int index = 0;
    foreach (SogliaItem s, m_Counter->Soglie){
        m_Bar = new QProgressBar(this);
        m_Bar->setMinimum(0);
        if (s.Soglia > 0)
            m_Bar->setMaximum(s.Soglia);
        else
            m_Bar->setMaximum(100);
        m_Bar->setValue(s.Utilizzato);
        if (settings)
            SetPercentageVisible(settings->ShowPercentage);
        m_Layout->addWidget(m_Bar, row, 0, 1, 2);

        if (m_Counter->WidgetSize == Counter::widgetMedium){
            row++;
            QLabel* lbl = new QLabel(this);
            lbl->setAlignment(Qt::AlignLeft);
            lbl->setText(tr("Util./Tot."));
            m_Layout->addWidget(lbl, row, 0, 1, 1);

            lbl = new QLabel(this);
            lbl->setAlignment(Qt::AlignRight);
            lbl->setText(QString("%1/%2").arg(s.Utilizzato).arg(s.Soglia));
            m_Layout->addWidget(lbl, row, 1, 1, 1);
        }else if (m_Counter->WidgetSize == Counter::widgetDetailed){
            QLabel* lbl = NULL;
            row++;
            if (s.Unita == "K"){
                lbl = new QLabel(this);
                lbl->setText(QString("%1 %2 / %3").arg(util).arg(CommonStatic::FormatKBytes(s.Utilizzato)).arg(CommonStatic::FormatKBytes(s.Soglia)));

                m_Layout->addWidget(lbl, row, 0, 1, 1);
            }else if (s.Unita == "A"){
                QString valuta = QChar(8364);
                lbl = new QLabel(this);
                lbl->setText(QString("%1 %2 %4/ %3 %4").arg(util).arg(s.Utilizzato, 4, 'f', 2).arg(s.Soglia, 4, 'f', 2).arg(valuta));

                m_Layout->addWidget(lbl, row, 0, 1, 1);
            }else if (s.Unita == "Y"){
                lbl = new QLabel(this);
                lbl->setText(QString("%1 %2 / %3").arg(util).arg(CommonStatic::FormatKBytes(s.Utilizzato * 1024.0)).arg(CommonStatic::FormatKBytes(s.Soglia * 1024.0)));

                m_Layout->addWidget(lbl, row, 0, 1, 1);
            }else if (s.Unita == "E"){
                lbl = new QLabel(this);
                lbl->setText(QString(tr("SMS utilizzati: %1 / %2")).arg(s.Utilizzato).arg(s.Soglia));

                m_Layout->addWidget(lbl, row, 0, 1, 1);
            }else if (s.Unita == "C"){
                lbl = new QLabel(this);
                lbl->setText(QString(tr("MMS utilizzati: %1 / %2")).arg(s.Utilizzato).arg(s.Soglia));

                m_Layout->addWidget(lbl, row, 0, 1, 1);
            }else if (s.Unita == "S"){
                lbl = new QLabel(this);
                if (m_Counter->Code == "ZERLIMON"){
                    switch (index){
                    case 1:
                            lbl->setText(QString(tr("Minuti chiamate utilizzati: %1 / %2")).arg(CommonStatic::FormatMinutes(s.Utilizzato)).arg(CommonStatic::FormatMinutes(s.Soglia)));
                            break;
                    case 3:
                            lbl->setText(QString(tr("Minuti videochiamate utilizzati: %1 / %2")).arg(CommonStatic::FormatMinutes(s.Utilizzato)).arg(CommonStatic::FormatMinutes(s.Soglia)));
                            break;
                    default:
                            lbl->setText(QString(tr("Minuti utilizzati: %1 / %2")).arg(CommonStatic::FormatMinutes(s.Utilizzato)).arg(CommonStatic::FormatMinutes(s.Soglia)));
                            break;
                    }

                }else{
                    lbl->setText(QString(tr("Minuti utilizzati: %1 / %2")).arg(CommonStatic::FormatMinutes(s.Utilizzato)).arg(CommonStatic::FormatMinutes(s.Soglia)));
                }
                m_Layout->addWidget(lbl, row, 0, 1, 1);
            } else if (s.Unita == "T"){
                lbl = new QLabel(this);
                lbl->setText(QString(tr("Scatti utilizzati: %1 / %2")).arg(s.Utilizzato).arg(s.Soglia));
                m_Layout->addWidget(lbl, row, 0, 1, 1);

                if (s.DimensioneScatto == "Secondi"){
                    lbl = new QLabel(this);
                    lbl->setAlignment(Qt::AlignRight);
                    lbl->setText(QString(tr("Ore: %1 / %2")).arg(CommonStatic::FormatHourMinutes(s.Utilizzato * s.Scatto)).arg(CommonStatic::FormatHourMinutes(s.Soglia * s.Scatto)));

    #ifdef Q_OS_SYMBIAN
                    lbl->setAlignment(Qt::AlignLeft);
                    m_Layout->addWidget(lbl, ++row, 0, 1, 1);
    #else
                    if (CommonStatic::IsPortrait()){
                        lbl->setAlignment(Qt::AlignLeft);
                        m_Layout->addWidget(lbl, ++row, 0, 1, 1);
                    }else
                        m_Layout->addWidget(lbl, row, 1, 1, 1);
    #endif
                }
            }

            row++;
            lbl = new QLabel(this);
    #ifdef Q_OS_SYMBIAN
            lbl->setText(QString(tr("Val.: %1 - %2")).arg(s.Periodo.toString("dd/MM/yyyy")).arg(s.DataUtile.toString("dd/MM/yyyy")));
    #else
            lbl->setText(QString(tr("Validit: %1 - %2")).arg(s.Periodo.toString("dd/MM/yyyy")).arg(s.DataUtile.toString("dd/MM/yyyy")));
    #endif
            m_Layout->addWidget(lbl, row, 0, 1, 1);
        }

        index++;
        row++;
    }
}

void CounterWidget::SetPercentageVisible(bool visible)
{
    if (m_Bar != NULL)
        m_Bar->setTextVisible(visible);
}
