//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "settings.h"
#include <QCoreApplication>
#include <QFile>
#include <QDir>
#include <QDebug>
#include "commonstatic.h"

Settings::Settings(QObject *parent, QString appletId) :
    QObject(parent)
{
    m_AppletId = appletId;

    StyleSheetName = "Default";
    ShowLabels = true;
    ShowCredito = true;
    ShowPunti = true;
    WidgetWidth = 200;
    CounterStyle = Counter::widgetMinimal;
    Animation = true;
    UpdateInterval = 0;
    LastCredito = 0;
    LastSaldoPunti = NULL;
}

QString Settings::GetConfigName()
{
    QString folder = CommonStatic::GetSettingsFolder();
    if (!QDir().exists(folder))
        QDir().mkdir(folder);
    return QString("%1/dwsettings.conf").arg(folder);
}

bool Settings::Save()
{
    qDebug() << "Saving settings";

    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup(m_AppletId);

    settings->setValue("counterstyle", CounterStyle);
    settings->setValue("animation", Animation);
    settings->setValue("widgetwidth", WidgetWidth);
    settings->setValue("stylesheet", StyleSheetName);
    settings->setValue("username", Username);
    settings->setValue("password", Password);
    settings->setValue("sim", SIM);
    settings->setValue("allsim", AllSIM);

    settings->setValue("labels", ShowLabels);
    settings->setValue("credito", ShowCredito);
    settings->setValue("punti", ShowPunti);
    settings->setValue("updateon", UpdateOn);
    settings->setValue("updateinterval", UpdateInterval);

    settings->setValue("lastcredito", LastCredito);
    settings->setValue("lastvaluta", LastValuta);
    if (LastSaldoPunti)
        settings->setValue("lastsaldopunti", LastSaldoPunti->ToString());

    settings->setValue("showpercentage", ShowPercentage);
    settings->beginWriteArray("counters");
    int size = ShowCounters.count();
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);
        settings->setValue("counter", ShowCounters.at(i)->ToString());
    }
    settings->endArray();

    settings->beginWriteArray("allcounters");
    size = AllCounters.count();
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);
        settings->setValue("counter", AllCounters.at(i)->ToString());
    }
    settings->endArray();

    settings->endGroup();
    settings->sync();

    delete settings;
    return true;
}

bool Settings::Load()
{
    if (!QFile::exists(GetConfigName()))
        return false;

    qDebug() << "Loading settings";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup(m_AppletId);

    CounterStyle = (Counter::widgetSize)settings->value("counterstyle", true).toInt();
    Animation = settings->value("animation", true).toBool();
    WidgetWidth = settings->value("widgetwidth", 200).toInt();
    StyleSheetName = settings->value("stylesheet", "Default").toString();
    Username = settings->value("username").toString();
    Password = settings->value("password").toString();
    SIM = settings->value("sim").toString();
    AllSIM = settings->value("allsim").toStringList();

    ShowLabels = settings->value("labels", true).toBool();
    ShowCredito = settings->value("credito", true).toBool();
    ShowPunti = settings->value("punti", true).toBool();
    UpdateOn = (connections)settings->value("updateon", connBoth).toInt();
    UpdateInterval = settings->value("updateinterval", 0).toInt();

    LastCredito = settings->value("lastcredito", 0).toFloat();
    LastValuta = settings->value("lastvaluta", "E").toString();
    if (LastValuta == "E")
        LastValuta = QChar(8364);

    QString saldo = settings->value("lastsaldopunti").toString();
    LastSaldoPunti = new SaldoPunti();
    LastSaldoPunti->FromString(saldo);

    ShowPercentage = settings->value("showpercentage", true).toBool();
    int size = settings->beginReadArray("counters");
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);

        Counter* c = new Counter();
        if (c->FromString(settings->value("counter").toString()))
            ShowCounters.append(c);
    }
    settings->endArray();

    size = settings->beginReadArray("allcounters");
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);

        Counter* c = new Counter();
        if (c->FromString(settings->value("counter").toString()))
            AllCounters.append(c);
    }
    settings->endArray();
    settings->endGroup();

    delete settings;
    return true;
}

QList<QString> Settings::GetAppletIds()
{
    QList<QString> res;
    if (!QFile::exists(GetConfigName()))
        return res;

    qDebug() << "Loading appletids";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");
    int size = settings->beginReadArray("appletids");
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);
        res.append(settings->value("appletid").toString());
    }
    settings->endArray();
    settings->endGroup();
    delete settings;

    return res;
}

void Settings::SaveAppletIds(QList<QString> ids)
{
    qDebug() << "Saving appletids";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");
    settings->beginWriteArray("appletids");
    int size = ids.count();
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);
        settings->setValue("appletid", ids.at(i));
    }
    settings->endArray();
    settings->endGroup();
    settings->sync();
}

void Settings::RemoveWidget(QString appletId)
{
    QList<QString> appletIds = GetAppletIds();
    appletIds.removeAll(appletId);
    SaveAppletIds(appletIds);

    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);
    settings->remove(appletId);
    settings->sync();
}
