//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef VODAFONEWIDGET_H
#define VODAFONEWIDGET_H

#include <QDebug>
#include <QObject>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkReply>
#include <QSslError>
#include <QNetworkCookieJar>
#include <QAuthenticator>
#include <QDomDocument>
#include <QEventLoop>
#include <QStringList>

#include "counter.h"
#include "saldopunti.h"
#include "infoconto.h"

// http://demos.vodafone.it/dw/getDWConfiguration.xml
// http://demos.vodafone.it/widget/contatori/getDWConfiguration.xml

//Cambio sim:
// https://widget.vodafone.it/190/trilogy/jsp/swapSim.do?ty_sim=xxxxxxxxxx

//Info conto:
// https://widget.vodafone.it/190/ebwe/mx/PushInfoconto.do?hpfdtpri=y

//Credito Residuo:
// https://widget.vodafone.it/190/fast/mx/CreditoResiduoPush.do?hpfdtpri=y

//Elenco contatori:
// https://widget.vodafone.it/190/ebwe/mx/Desktopwidgetconto.do

//Dettaglio contatore:
// https://widget.vodafone.it/190/ebwe/mx/DesktopwidgetContatoreDettagli.do?ProductType=P&Classe=2&ProductCode=888

class VodafoneWidget : public QObject
{
    Q_OBJECT
public:
    enum SimType {
        SimUnknown,
        SimRicaricabile,
        SimContratto,
    };

    VodafoneWidget(QString username, QString password);
     ~VodafoneWidget();

    int RequestTimeoutMsec;
    bool DebugXml;
    void SetCredentials(QString username, QString password);
    bool IsLoggedIn();
    bool Login();
    void Logout();

    QStringList GetSims();
    QString GetCurrentSim();
    SimType GetCurrentSimType();

    bool SetCurrentSim(QString sim);

    float GetCredito(QString* valuta);
    bool GetInfoConto(InfoConto* info);
    QList<Counter*>* GetListaContatori(bool includeStandard=false);
    bool GetDettaglioContatore(Counter* counter);
    bool GetSaldoPunti(SaldoPunti* saldo);

    bool PrepareMessage(QString receiver, QString message, QByteArray* captchaImage, QString* errorMessage=0);
    bool SendMessage(QString receiver, QString message, QString captcha, QString* errorMessage=0);    

private:
    QStringList m_Sims;
    QString m_CurrentSim;
    SimType m_CurrentSimType;

    bool m_Aborting;
    QNetworkReply* m_CurrentReply;

    QString m_SessionID;
    QNetworkCookieJar* m_CookieJar;
    QNetworkAccessManager* m_Nam;

    QString m_Username;
    QString m_Password;

    QString GetReturnCode(QDomDocument doc);
    QString GetStatus(QDomDocument doc, QString* errorMessage=0);
    QNetworkRequest PrepareRequest(QUrl url, bool vodafoneUserAgent=true);
    QNetworkRequest PrepareRequest(QString url, bool vodafoneUserAgent=true);
    QString SynchRequest(QNetworkRequest* request, QUrl* redirectUrl=NULL);

    QString Decrypt(QString* crypted, QString* sessionID);
    float GetCounterFloatValue(QString value);

private slots:
    void AbortRequest();
};

#endif // VODAFONEWIDGET_H
