//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "settings.h"
#include <QCoreApplication>
#include <QFile>
#include <QDir>
#include "commonstatic.h"

Settings::Settings(QObject *parent) :
    QObject(parent)
{
    StyleSheetName = "Default";
    ShowStandardCounters = false;
    ShowPercentage = true;
    SaveSentSms = true;
    LogXml = false;
    SmsSent = 0;
    ShowLastData = true;    
    LastCredito = 0;
    LastSaldoPunti = NULL;
    LastCounters = NULL;
}

QString Settings::GetConfigName()
{
#ifdef Q_WS_MAEMO_5
    QString folder = CommonStatic::GetSettingsFolder();
    if (!QDir().exists(folder))
        QDir().mkdir(folder);
    return QString("%1/settings.conf").arg(folder);
#else
    return QString("%1/settings.conf").arg(CommonStatic::GetSettingsFolder());
#endif
}

bool Settings::Save()
{
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");

    settings->setValue("stylesheet", StyleSheetName);
    settings->setValue("username", Username);
    settings->setValue("password", Password);
    settings->setValue("logxml", LogXml);
    settings->setValue("showpercentage", ShowPercentage);
    settings->setValue("showstandardcounters", ShowStandardCounters);
    settings->setValue("savesentsms", SaveSentSms);

    settings->setValue("smsdate", SmsDate);
    settings->setValue("smssent", SmsSent);
    settings->setValue("showlastdata", ShowLastData);
    settings->setValue("lastupdated", LastUpdated);
    settings->setValue("lastcredito", LastCredito);
    settings->setValue("lastvaluta", LastValuta);
    if (LastSaldoPunti)
        settings->setValue("lastsaldopunti", LastSaldoPunti->ToString());

    if (LastCounters){
        settings->beginWriteArray("counters");
        for (int i = 0; i < LastCounters->count(); ++i) {
            settings->setArrayIndex(i);
            settings->setValue("counter", LastCounters->at(i)->ToString());
        }
        settings->endArray();
    }

    settings->endGroup();
    settings->sync();

    return true;
}

bool Settings::Load()
{
    if (!QFile::exists(GetConfigName()))
        return false;

    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");

    StyleSheetName = settings->value("stylesheet", "default").toString();
    Username = settings->value("username").toString();
    Password = settings->value("password").toString();
    LogXml = settings->value("logxml", false).toBool();
    ShowPercentage = settings->value("showpercentage", true).toBool();
    ShowStandardCounters = settings->value("showstandardcounters", false).toBool();
    SaveSentSms = settings->value("savesentsms", true).toBool();

    SmsDate = settings->value("smsdate").toDate();
    SmsSent = settings->value("smssent").toInt();
    ShowLastData = settings->value("showlastdata", true).toBool();
    LastUpdated = settings->value("lastupdated").toDateTime();
    LastCredito = settings->value("lastcredito", 0).toFloat();
    LastValuta = settings->value("lastvaluta", "E").toString();
    QString saldo = settings->value("lastsaldopunti").toString();
    LastSaldoPunti = new SaldoPunti();
    LastSaldoPunti->FromString(saldo);

    LastCounters = new QList<Counter*>();
    int max = settings->beginReadArray("counters");
    for (int i = 0; i < max; ++i) {
        settings->setArrayIndex(i);

        Counter* c = new Counter();
        if (c->FromString(settings->value("counter").toString()))
            LastCounters->append(c);
    }
    settings->endArray();

    settings->endGroup();

    if (!SmsDate.isValid() || SmsDate != QDate::currentDate()){
        SmsDate = QDate::currentDate();
        SmsSent = 0;
    }
    return true;
}
