//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef CONTACTWIDGET_H
#define CONTACTWIDGET_H

#include <QLabel>
#include <QFrame>
#include <QGridLayout>
#include <QMouseEvent>
#include <QTime>
#include "contact.h"

class ContactWidget : public QFrame
{
    Q_OBJECT
    Q_PROPERTY(bool userSelected READ IsPressed)

public:

    ContactWidget(QWidget *parent = 0, Contact* contact=0, QPixmap* defaultImage=0);
    bool IsPressed();
    void SelectText(QString select);

private:
    Contact* m_Contact;

    QGridLayout* m_Layout;
    QLabel* m_NameLabel;

    int m_PressedPosY;
    QTime m_PressedTime;
    bool m_Pressed;
    bool m_Sunken;
    void mousePressEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);
    void leaveEvent(QEvent* event);
    void enterEvent(QEvent* event);

signals:
    void clicked();
};

#endif // CONTACTWIDGET_H
