//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactwidget.h"
#include <QLabel>
#include "commonstatic.h"
#include <QStyleOption>
#include <QPainter>

ContactWidget::ContactWidget(QWidget *parent, Contact* contact, QPixmap* defaultImage) :
    QFrame(parent)
{
    m_Contact = contact;

    m_Sunken = false;
    m_Pressed = false;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    setContentsMargins(0,0,0,0);
#ifdef Q_OS_SYMBIAN
    setMaximumHeight(56);
#endif

    m_Layout = new QGridLayout( this );
    m_Layout->setSpacing(3);
    m_Layout->setContentsMargins(0,0,0,0);
    this->setLayout(m_Layout);

    QLabel* lbl = new QLabel(this);
    lbl->setAlignment(Qt::AlignCenter);
    lbl->setMaximumSize(48, 48);
    if (m_Contact->Thumbnail != NULL)
        lbl->setPixmap(QPixmap::fromImage(*m_Contact->Thumbnail).scaled(48, 48, Qt::KeepAspectRatio));
    else{
        QPixmap* cImage = defaultImage;
        if (cImage == NULL)
            cImage = new QPixmap(":/images/contacts.png");
        lbl->setPixmap(cImage->scaled(48, 48, Qt::KeepAspectRatio));
    }
    m_Layout->addWidget(lbl, 0, 0, 2, 1);

    m_NameLabel = new QLabel(this);
    m_NameLabel->setText(QString("<b>%1</b>").arg(m_Contact->Name));
    m_Layout->addWidget(m_NameLabel, 0, 1, 1, 1);

    lbl = new QLabel(this);
    lbl->setText(m_Contact->MobileNumber);
    m_Layout->addWidget(lbl, 1, 1, 1, 1);
}


void ContactWidget::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton){
        m_PressedPosY = QCursor::pos().y();
        m_PressedTime.start();
        m_Pressed = true;
        m_Sunken = true;
    }
}

void ContactWidget::mouseReleaseEvent(QMouseEvent*)
{
    m_Sunken = false;
    if (m_Pressed && CommonStatic::IsMouseOver(this) &&
        abs(m_PressedPosY - QCursor::pos().y()) < height() / 2 &&
        m_PressedTime.elapsed() >= 50)
        emit clicked();
    m_Pressed = false;
    m_PressedTime = QTime();
}

void ContactWidget::leaveEvent(QEvent*)
{
    if (m_Pressed){
        m_Sunken = false;
    }
}

void ContactWidget::enterEvent(QEvent*)
{
    if (m_Pressed){
        m_Sunken = true;
    }
}


bool ContactWidget::IsPressed(){
    return m_Sunken;
}

void ContactWidget::SelectText(QString select)
{
    QString text = m_Contact->Name;
    text.replace(select, QString("<b>%1</b>").arg(select), Qt::CaseInsensitive);
    m_NameLabel->setText(text);
    m_NameLabel->update();
}
