//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "simswindow.h"
#include "ui_simswindow.h"

#include "widgets/simwidget.h"

SimsWindow::SimsWindow(QWidget *parent, QStringList* sims) :
    QDialog(parent),
    ui(new Ui::SimsWindow)
{
    ui->setupUi(this);

#ifdef Q_OS_SYMBIAN
    QAction* softKey = new QAction( tr("Seleziona"), this );
    softKey->setSoftKeyRole( QAction::PositiveSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(accept()));
    addAction(softKey);

    softKey = new QAction( tr("Indietro"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

    if (ui->scrollAreaWidgetContents->layout() == NULL){
        QVBoxLayout* layout = new QVBoxLayout(ui->scrollAreaWidgetContents);
        ui->scrollAreaWidgetContents->setLayout(layout);
        layout->setAlignment(Qt::AlignTop);
        layout->setSpacing(0);
        layout->setContentsMargins(3,3,3,3);
    }

    foreach(QString sim, *sims){
        SimWidget* w = new SimWidget(this, &sim);
        connect(w, SIGNAL(clicked()), this, SLOT(SelectSimSlot()));
        ui->scrollAreaWidgetContents->layout()->addWidget(w);
    }
}

SimsWindow::~SimsWindow()
{
    delete ui;
}


QString SimsWindow::GetSelectedSim()
{
    return m_SelectedSim;
}

void SimsWindow::SelectSimSlot()
{
    m_SelectedSim = ((SimWidget*)sender())->Number;
    accept();
}
