//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "commonstatic.h"
#include <QDir>
#include <QListView>

SettingsWindow::SettingsWindow(QWidget *parent, Settings* settings) :
    QDialog(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);

    m_Settings = settings;
    connect(ui->btnCancel, SIGNAL(clicked()), this, SLOT(CancelSlot()));
    connect(ui->btnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));

#ifdef Q_OS_SYMBIAN
    ui->lblShowLastData->setText(tr("Visualizza dati all'avvio:"));

    ui->btnCancel->setVisible(false);
    ui->btnSave->setVisible(false);

    QAction* softKey = new QAction( tr("Ok"), this );
    softKey->setSoftKeyRole( QAction::PositiveSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(SaveSlot()));
    addAction(softKey);

    softKey = new QAction( tr("Annulla"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(CancelSlot()));
    addAction(softKey);
#endif

    ui->txUsername->setText(m_Settings->Username);
    ui->txPassword->setText(m_Settings->Password);
    ui->chkLogXML->setChecked(m_Settings->LogXml);
    ui->chkShowLastData->setChecked(m_Settings->ShowLastData);
    ui->chkPerc->setChecked(m_Settings->ShowPercentage);
    ui->chkShowStdCounters->setChecked(m_Settings->ShowStandardCounters);
#ifdef Q_WS_MAEMO_5
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->cmbStyleSheet->clear();
    ui->cmbStyleSheet->addItem("Default", "Default");
    ui->cmbStyleSheet->addItem("System", "System");
    foreach (QString s, GetStyleSheets()){
        QString name = s;
        name.remove(name.length() - 4, 4);
        ui->cmbStyleSheet->addItem(name, s);
    }
    int index = ui->cmbStyleSheet->findText(m_Settings->StyleSheetName);
    if (index < 0)
        index = 0;
    ui->cmbStyleSheet->setCurrentIndex(index);
    ui->cmbStyleSheet->setView(new QListView());

    connect(ui->cmbStyleSheet, SIGNAL(activated(int)), SLOT(StyleSlot(int)));
    ui->txUsername->setFocus();
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::CancelSlot()
{
    StyleSlot(ui->cmbStyleSheet->findText(m_Settings->StyleSheetName));
    reject();
}

void SettingsWindow::SaveSlot()
{
    m_Settings->StyleSheetName = ui->cmbStyleSheet->currentText();
    m_Settings->Username = ui->txUsername->text();
    m_Settings->Password = ui->txPassword->text();
    m_Settings->LogXml = ui->chkLogXML->isChecked();
    m_Settings->ShowLastData = ui->chkShowLastData->isChecked();
    m_Settings->ShowPercentage = ui->chkPerc->isChecked();
    m_Settings->ShowStandardCounters = ui->chkShowStdCounters->isChecked();

    m_Settings->Save();

    StyleSlot(ui->cmbStyleSheet->findText(m_Settings->StyleSheetName));
    accept();
}

QStringList SettingsWindow::GetStyleSheets()
{
    QDir myDir(CommonStatic::GetStylesheetFolder());
    QStringList ext = QStringList() << "*.css";
    return myDir.entryList(ext);
}

void SettingsWindow::StyleSlot(int index)
{
    if (index == 0)
        CommonStatic::SetDefaultStylesheet();
    else if (index == 1)
        qApp->setStyleSheet("");
    else{
        QString filename = QString("%1/%2").arg(CommonStatic::GetStylesheetFolder())
                                           .arg(ui->cmbStyleSheet->itemData(ui->cmbStyleSheet->currentIndex()).toString());
        CommonStatic::SetStylesheet(filename);
    }
}
