#include "counterwidget.h"
#include "commonstatic.h"
#include "qtitlelabel.h"

CounterWidget::CounterWidget(QWidget *parent, Counter* counter, Settings* settings) :
    QScrollArea(parent)
{    

    m_Counter = counter;

    m_Bar = NULL;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setWidgetResizable(true);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);

    m_Container = new QWidget(this);
    m_Container->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Maximum);
    setWidget(m_Container);

    m_Layout = new QGridLayout( m_Container );
    m_Layout->setSpacing(6);
    m_Layout->setContentsMargins(0,0,0,0);
    m_Container->setLayout(m_Layout);

    CreateWidgets(settings);
}

CounterWidget::~CounterWidget()
{
    delete m_Layout;
    delete m_Container;
}

void CounterWidget::CreateWidgets(Settings* settings)
{
    int row = 0;
    QTitleLabel* titleLbl = new QTitleLabel(this);
    titleLbl->setWordWrap(true);
    titleLbl->setText(m_Counter->Description);
    m_Layout->addWidget(titleLbl, row, 0, 1, 2);

    row++;
    m_Bar = new QProgressBar(this);
    m_Bar->setMinimum(0);
    if (m_Counter->Soglia > 0)
        m_Bar->setMaximum(m_Counter->Soglia);
    else
        m_Bar->setMaximum(100);
    m_Bar->setValue(m_Counter->Utilizzato);
    if (settings)
        SetPercentageVisible(settings->ShowPercentage);
    m_Layout->addWidget(m_Bar, row, 0, 1, 2);

    QLabel* lbl = NULL;
    row++;
    if (m_Counter->Unita == "K"){
        lbl = new QLabel(this);
        lbl->setText(QString(tr("Traff. utilizzato: %1 / %2")).arg(CommonStatic::FormatKBytes(m_Counter->Utilizzato)).arg(CommonStatic::FormatKBytes(m_Counter->Soglia)));

        m_Layout->addWidget(lbl, row, 0, 1, 1);
    }else if (m_Counter->Unita == "A"){
        QString valuta = QChar(8364);
        lbl = new QLabel(this);
        lbl->setText(QString(tr("Traff. utilizzato: %1 %3/ %2 %3")).arg(m_Counter->Utilizzato, 4, 'f', 2).arg(m_Counter->Soglia, 4, 'f', 2).arg(valuta));

        m_Layout->addWidget(lbl, row, 0, 1, 1);
    }else if (m_Counter->Unita == "Y"){
        lbl = new QLabel(this);
        lbl->setText(QString(tr("Traff. utilizzato: %1 / %2")).arg(CommonStatic::FormatKBytes(m_Counter->Utilizzato * 1024.0)).arg(CommonStatic::FormatKBytes(m_Counter->Soglia * 1024.0)));

        m_Layout->addWidget(lbl, row, 0, 1, 1);
    } else if (m_Counter->Unita == "T"){
        lbl = new QLabel(this);
        lbl->setText(QString(tr("Scatti utilizzati: %1 / %2")).arg(m_Counter->Utilizzato).arg(m_Counter->Soglia));
        m_Layout->addWidget(lbl, row, 0, 1, 1);

        if (m_Counter->DimensioneScatto == "Secondi"){
            lbl = new QLabel(this);
            lbl->setAlignment(Qt::AlignRight);
            lbl->setText(QString(tr("Ore: %1 / %2")).arg(ToHourMinutes(m_Counter->Utilizzato * m_Counter->Scatto)).arg(ToHourMinutes(m_Counter->Soglia * m_Counter->Scatto)));

    #ifdef Q_OS_SYMBIAN
            lbl->setAlignment(Qt::AlignLeft);
            m_Layout->addWidget(lbl, ++row, 0, 1, 1);
    #else
            if (CommonStatic::IsPortrait()){
                lbl->setAlignment(Qt::AlignLeft);
                m_Layout->addWidget(lbl, ++row, 0, 1, 1);
            }else
                m_Layout->addWidget(lbl, row, 1, 1, 1);
    #endif
        }
    }

    row++;
    lbl = new QLabel(this);
#ifdef Q_OS_SYMBIAN
    lbl->setText(QString(tr("Val.: %1 - %2")).arg(m_Counter->Periodo.toString("dd/MM/yyyy")).arg(m_Counter->DataUtile.toString("dd/MM/yyyy")));
#else
    lbl->setText(QString(tr("Validit: %1 - %2")).arg(m_Counter->Periodo.toString("dd/MM/yyyy")).arg(m_Counter->DataUtile.toString("dd/MM/yyyy")));
#endif
    m_Layout->addWidget(lbl, row, 0, 1, 1);
}

QString CounterWidget::ToHourMinutes(int seconds)
{
    int hh = seconds / 3600;
    int mm = (seconds - (hh * 3600)) / 60;
    QString s;
    return QString("%1:%2").arg(hh, 2, 10, QChar('0')).arg(mm, 2, 10, QChar('0'));
}

void CounterWidget::SetPercentageVisible(bool visible)
{
    if (m_Bar != NULL)
        m_Bar->setTextVisible(visible);
}
