#ifndef CONTACTWIDGET_H
#define CONTACTWIDGET_H

#include <QScrollArea>
#include <QGridLayout>
#include <QMouseEvent>
#include "contact.h"

class ContactWidget : public QScrollArea
{
    Q_OBJECT
public:
    ContactWidget(QWidget *parent = 0, Contact* contact=0, QPixmap* defaultImage=0);

private:
    Contact* m_Contact;

    QWidget* m_Container;
    QGridLayout* m_Layout;

    bool m_Pressed;
    void mousePressEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);
    void leaveEvent(QEvent* event);
    void enterEvent(QEvent* event);

    void SetStyle(bool selected);

signals:
    void clicked();
};

#endif // CONTACTWIDGET_H
