//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include <QtGui/QApplication>
#include "mainwindow.h"
#include <fstream>
#include <QFile>
#include <QDir>
#include "commonstatic.h"

#define QUOTE_(x) #x
#define QUOTE(x) QUOTE_(x)

using namespace std;
ofstream logfile;
void SimpleLoggingHandler(QtMsgType type, const char *msg) {
    switch (type) {
        case QtDebugMsg:
            logfile << QTime::currentTime().toString().toAscii().data() << " Debug: " << msg << "\n";
            break;
        case QtCriticalMsg:
            logfile << QTime::currentTime().toString().toAscii().data() << " Critical: " << msg << "\n";
            break;
        case QtWarningMsg:
            logfile << QTime::currentTime().toString().toAscii().data() << " Warning: " << msg << "\n";
            break;
        case QtFatalMsg:
            logfile << QTime::currentTime().toString().toAscii().data() <<  " Fatal: " << msg << "\n";
            abort();
        }
    logfile.flush();
}

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    a.setApplicationVersion(QUOTE(APP_VERSION));

    qApp->setStyleSheet("QMainWindow{ \
                           background: white; \
                         } \
                         QDialog{ \
                           background: white; \
                         } \
                         QGroupBox{ \
                           color: red; \
                           background: white; \
                         } \
                         QLineEdit{ \
                            color: black; \
                            border-width: 1px; \
                            border-style: solid; \
                            border-color: black; \
                         } \
                         QLineEdit:focus{ \
                            color: black; \
                            border-width: 2px; \
                            border-style: solid; \
                            border-color: red; \
                         } \
                         QPlainTextEdit{ \
                            color: black; \
                            border-width: 1px; \
                            border-style: solid; \
                            border-color: black; \
                         } \
                         QPlainTextEdit:focus{ \
                            color: black; \
                            border-width: 2px; \
                            border-style: solid; \
                            border-color: red; \
                         } \
                         QPushButton{ \
                            border-radius: 10px; \
                            min-width: 64; \
                            height: 64; \
                            color: black; \
                            border-width: 1px; \
                            border-style: solid; \
                            border-color: black; \
                         } \
                         QPushButton:pressed{ \
                            border-width: 2px; \
                            border-color: red; \
                         } \
                         QPushButton[flat=\"true\"]{ \
                            border-width: 0; \
                         } \
                         QPushButton[flat=\"true\"]:pressed{ \
                            border-width: 2px; \
                            border-color: red; \
                         } \
                         QCheckBox::indicator:unchecked { \
                            image: url(:/images/checkbox.png); \
                            height: 32; \
                            width: 32; \
                         } \
                         QCheckBox::indicator:checked { \
                            image: url(:/images/checkbox_checked.png); \
                            height: 32; \
                            width: 32; \
                         } \
                         ");

    MainWindow w;

#ifdef Q_WS_MAEMO_5
    QString folder = QString("%1/.vodafone190").arg(CommonStatic::GetHomeFolder());
    if (!QDir().exists(folder))
        QDir().mkdir(folder);

    QString logFileName = QString("%1/vodafone190.log").arg(folder);
#else
    QString logFileName = "c:\\data\\vodafone190.log";
#endif
    if (QFile::exists(logFileName))
        QFile::remove(logFileName);

    QByteArray ba = logFileName.toLatin1();
    const char* c_str = ba.data();
    logfile.open(c_str, ios::app);
    qInstallMsgHandler(SimpleLoggingHandler);

#if defined(Q_OS_SYMBIAN)
    /* Remove context menu from the all widgets. */
    QWidgetList widgets = QApplication::allWidgets();
    QWidget* widget=0;
    foreach(widget,widgets)
        widget->setContextMenuPolicy(Qt::NoContextMenu);

    w.showMaximized();
#else
    w.show();
#endif

    w.Init();
    int returnCode = a.exec();

    logfile.close();
    return returnCode;
}
