#include "captchawindow.h"
#include "ui_captchawindow.h"
#include "commonstatic.h"

CaptchaWindow::CaptchaWindow(QWidget *parent, QPixmap* captchaImage) :
    QDialog(parent),
    ui(new Ui::CaptchaWindow)
{
    ui->setupUi(this);

    ui->lblCaptcha->setPixmap(*captchaImage);

    connect(ui->btnOK, SIGNAL(clicked()), this, SLOT(OkSlot()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

#ifdef Q_OS_SYMBIAN
    ui->btnOK->setVisible(false);

    QAction* softKey = new QAction( tr("Ok"), this );
    softKey->setSoftKeyRole( QAction::PositiveSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(OkSlot()));
    addAction(softKey);

    softKey = new QAction( tr("Annulla"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

    ui->txtCaptcha->grabKeyboard();
}

CaptchaWindow::~CaptchaWindow()
{
    delete ui;
}

void CaptchaWindow::OkSlot()
{
    if (ui->txtCaptcha->text().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Inserire il captcha"));
        return;
    }

    m_Captcha = ui->txtCaptcha->text();
    accept();
}

QString CaptchaWindow::GetCaptcha()
{
    return m_Captcha;
}
