#include "smswindow.h"
#include "ui_smswindow.h"
#include <QMovie>
#include <QRegExp>

#include "commonstatic.h"
#include "captchawindow.h"
#include "contactswindow.h"

SmsWindow::SmsWindow(QWidget *parent, VodafoneWidget* vodafone) :
    QDialog(parent),
    ui(new Ui::SmsWindow)
{
    ui->setupUi(this);

    m_Vodafone = vodafone;
    connect(ui->btnContacts, SIGNAL(clicked()), this, SLOT(ContactsSlot()));
    connect(ui->btnSend, SIGNAL(clicked()), this, SLOT(SendSlot()));    
    connect(ui->btnCancel, SIGNAL(clicked()), this, SLOT(CancelSlot()));
    connect(ui->txtMessage, SIGNAL(textChanged()), this, SLOT(MessageChangedSlot()));

#ifdef Q_WS_MAEMO_5
    ui->lblWait->setVisible(false);
    ui->txtReceiver->setInputMethodHints(Qt::ImhDigitsOnly);
#else
    QRegExp re("+?[0-9]*");
    QRegExpValidator *validator = new QRegExpValidator(re, this);
    ui->txtReceiver->setValidator(validator);
#endif

    MessageChangedSlot();
}

SmsWindow::~SmsWindow()
{
    delete ui;
}

void SmsWindow::ContactsSlot()
{
    ContactsWindow* frm = new ContactsWindow(this);
    frm->show();
    frm->Init();
    if (frm->exec() == QDialog::Accepted)
        ui->txtReceiver->setText(frm->GetSelectedNumber());
    delete frm;
}

void SmsWindow::SendSlot()
{
    if (ui->txtReceiver->text().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Inserire un destinatario"));
        return;
    }

    if (ui->txtMessage->toPlainText().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Inserire un messaggio"));
        return;
    }

    bool send = true;
    QString error;
    QByteArray captchaImage;
    QString captcha;

    ui->btnSend->setEnabled(false);
    ui->txtReceiver->setEnabled(false);
    ui->txtMessage->setEnabled(false);

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#else
    QMovie* waitIcon = new QMovie(":/images/wait.gif");
    waitIcon->setScaledSize(QSize(40, 40));
    ui->lblWait->setMovie(waitIcon);
    waitIcon->start();
#endif

    if (!m_Vodafone->IsLoggedIn()){
        if (!m_Vodafone->Login()){
            CommonStatic::ErrorMessage(this, tr("Login fallito"));
            send = false;
        }
    }

    if (send){
        if (m_Vodafone->PrepareMessage(ui->txtReceiver->text(), ui->txtMessage->toPlainText(), &captchaImage, &error)){
            if (captchaImage.count() > 0){
                QPixmap* pixmap = new QPixmap();
                pixmap->loadFromData(captchaImage);
                *pixmap = pixmap->scaled(pixmap->width() * 3, pixmap->height() * 3);

                CaptchaWindow* frm = new CaptchaWindow(this, pixmap);
                frm->exec();
                captcha = frm->GetCaptcha();
            }
            if (m_Vodafone->SendMessage(ui->txtReceiver->text(), ui->txtMessage->toPlainText(), captcha, &error)){
                CommonStatic::InfoMessage(this, tr("SMS inviato"));
                accept();
            }else{
                StopWait();
                CommonStatic::ErrorMessage(this, error.isEmpty() ? tr("Captcha errato") : error);
            }
        }else{
            StopWait();
            CommonStatic::ErrorMessage(this, error.isEmpty() ? tr("Invio fallito") : error);
        }
    }

    StopWait();
    ui->btnSend->setEnabled(true);
    ui->txtReceiver->setEnabled(true);
    ui->txtMessage->setEnabled(true);
}

void SmsWindow::StopWait()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#else
    ui->lblWait->setMovie(NULL);
    ui->lblWait->setPixmap(NULL);
#endif
}

void SmsWindow::CancelSlot()
{
    reject();
}

void SmsWindow::MessageChangedSlot()
{
    int chars = ui->txtMessage->toPlainText().length();
    ui->lblCharacters->setText(QString(tr("Caratteri: %1/360")).arg(chars));
    if (chars < 0)
        ui->lblCharacters->setStyleSheet("color: red;");
    else
        ui->lblCharacters->setStyleSheet("color: black;");
}
