#include "commonstatic.h"
#include <QMessageBox>
#include <QApplication>
#include <QDesktopWidget>
#ifdef Q_WS_MAEMO_5
    #include <QDesktopServices>
    #include <QMaemo5InformationBox>
    #include <QLabel>
    #include <QVBoxLayout>
#endif
#include <QDir>

void CommonStatic::ErrorMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setStyleSheet("background: white; color: red; opacity: 223;");
    box->setTimeout(-1);

    QLabel* text = new QLabel(box);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

void CommonStatic::InfoMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setStyleSheet("background: white; color: red; opacity: 223;");

    QLabel* text = new QLabel(box);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
#endif
}


bool CommonStatic::IsPortrait()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    return screenGeometry.height() > screenGeometry.width();
}

QString CommonStatic::GetHomeFolder()
{
#ifdef Q_WS_MAEMO_5
    return QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
#else
    return QDir::homePath()
#endif
}
