#include "aboutwindow.h"
#include "ui_aboutwindow.h"
#include <QFile>
#include "texteditautoresizer.h"
#ifdef Q_WS_MAEMO_5
    #include <QDesktopServices>
    #include <QUrl>
#endif

AboutWindow::AboutWindow(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AboutWindow)
{
    ui->setupUi(this);

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
#endif
    new TextEditAutoResizer(ui->txtAbout);
    new TextEditAutoResizer(ui->txtLicense);

    connect(ui->btnDonate, SIGNAL(clicked()), this, SLOT(DonateSlot()));
}

AboutWindow::~AboutWindow()
{
    delete ui;
}

void AboutWindow::Init()
{
    QFile* file = new QFile(":/ABOUT.HTML");
    if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
        QByteArray data = file->readAll();
        QString about(data);
        about.replace("%VERSION%", QCoreApplication::applicationVersion());
        ui->txtAbout->setHtml(about);
        file->close();
    }
    delete file;

    file = new QFile(":/LICENSE.HTML");
    if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
        QByteArray data = file->readAll();
        ui->txtLicense->setHtml(QString(data));
        file->close();
    }
    delete file;
}

void AboutWindow::resizeEvent(QResizeEvent* event)
{
    //Update license text to let TextEditAutoResizer resize the QTextEdit
    ui->txtLicense->setHtml(ui->txtLicense->toHtml());
}

void AboutWindow::DonateSlot()
{
#ifdef Q_WS_MAEMO_5
    QUrl url("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=BNZC7EH2WBN3C");
    QDesktopServices::openUrl(url);
#endif
}
