/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include "appsettings.h"

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();


//static QString  currentIp();

public slots:
    void init();
    void setOrientationLandscape();
    void setOrientationPortrait();
    void setOrientationAutoRotate();
    void setStatusPollTimeout(int);
    void setPingTimeout(int);
    void setConnectionTimeout(int);
    void setRetrieveArtTimeout(int);
    void setRetryNetworkTimeout(int);
    void setShowUnknownFileTypes(bool);
    void setShowAlbumArt(bool);
    void setAlertOnClose(bool);

protected:
    void closeEvent(QCloseEvent *);
    void setOrientation(Orientation);

private:
    Ui::SettingsDialog *ui;

signals:
    void closeSignal();
};

#endif // SETTINGSDIALOG_H
